<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class TherapistMainCategoriesTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        

        \DB::table('therapist_main_categories')->delete();
        
        \DB::table('therapist_main_categories')->insert(array (
            0 => 
            array (
                'created_at' => '2023-08-03 12:06:22',
                'deleted_at' => NULL,
                'description' => '{"en":"<p>Administrative Therapy, also known as Regulatory Therapy, is a branch of therapy that governs the organization, powers, procedures, and functions of administrative agencies. These agencies are created by governments to carry out specific tasks, enforce therapys, and implement policies in various areas of public interest. Administrative therapy is concerned with the relationship between these agencies and the individuals or entities subject to their jurisdiction.<\\/p>\\r\\n\\r\\n<p>Key Elements of Administrative \\/ Regulatory Therapy:<\\/p>\\r\\n\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p>Administrative Agencies: Administrative agencies are bodies established by legislatures or executive orders to manage specific areas of government functions. These agencies may be at the federal, state, or local levels and have various responsibilities, such as regulating industries, overseeing public services, granting licenses, and ensuring compliance with therapys and regulations.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Rulemaking: One of the essential functions of administrative agencies is the promulgation of rules and regulations. These rules are formulated to provide details and guidance on how the therapys passed by the legislature will be implemented and enforced. Rulemaking processes typically involve public notice, comment periods, and a formal adoption process to ensure transparency and accountability.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Adjudication: Administrative agencies often have quasi-judicial powers, allowing them to resolve disputes between parties or enforce compliance with regulations. Administrative hearings are conducted to determine facts, interpret rules, and render decisions on specific cases brought before the agency.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Judicial Review: Administrative decisions are subject to judicial review to ensure they comply with the therapy and do not exceed the agency&#39;s authority. Courts can overturn agency actions that are deemed arbitrary, capricious, or contrary to therapy. Judicial review provides a check on the agencies&#39; exercise of power and helps maintain the balance between the executive, legislative, and judicial branches of government.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Due Process: Individuals and businesses subject to administrative actions have the right to due process, which includes notice of the charges or allegations against them and an opportunity to be heard before an impartial decision-maker. Due process protections help safeguard individual rights and prevent arbitrary actions by administrative agencies.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Enforcement and Sanctions: Administrative agencies have the authority to enforce their regulations through various means, including fines, penalties, license revocation, and other administrative sanctions. Enforcement actions aim to ensure compliance with the therapy and protect the public interest.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Public Participation: Administrative agencies often seek public input and participation in the rulemaking process, allowing stakeholders and the general public to voice their opinions, concerns, and expertise on proposed regulations. Public participation is critical to crafting effective and balanced regulations that consider various perspectives.<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n\\r\\n<p>Overall, administrative\\/regulatory therapy plays a crucial role in shaping and implementing government policies, ensuring the efficient functioning of administrative agencies, and protecting the rights and interests of individuals and entities affected by their actions.<\\/p>","hi":"<p>\\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915 \\u0915\\u093e\\u0928\\u0942\\u0928, \\u091c\\u093f\\u0938\\u0947 \\u0935\\u093f\\u0928\\u093f\\u092f\\u093e\\u092e\\u0915 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u092d\\u0940 \\u0915\\u0939\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948, \\u090f\\u0915 \\u0910\\u0938\\u093e \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u093e \\u0936\\u093e\\u0916\\u093e \\u0939\\u0948 \\u091c\\u094b \\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915 \\u090f\\u091c\\u0947\\u0902\\u0938\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u0902\\u0917\\u0920\\u0928, \\u0936\\u0915\\u094d\\u0924\\u093f\\u092f\\u094b\\u0902, \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e\\u0913\\u0902 \\u0914\\u0930 \\u0915\\u093e\\u0930\\u094d\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0928\\u093f\\u092f\\u0902\\u0924\\u094d\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0947 \\u090f\\u091c\\u0947\\u0902\\u0938\\u093f\\u092f\\u093e\\u0901 \\u0938\\u0930\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u092c\\u0928\\u093e\\u0908 \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948\\u0902 \\u0924\\u093e\\u0915\\u093f \\u0935\\u093f\\u0936\\u093f\\u0937\\u094d\\u091f \\u0915\\u093e\\u0930\\u094d\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0938\\u0902\\u092d\\u093e\\u0932 \\u0938\\u0915\\u0947\\u0902, \\u0915\\u093e\\u0928\\u0942\\u0928\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0947\\u0902 \\u0914\\u0930 \\u0938\\u093e\\u0930\\u094d\\u0935\\u091c\\u0928\\u093f\\u0915 \\u0939\\u093f\\u0924 \\u0915\\u0947 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0928\\u0940\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0915\\u093e\\u0930\\u094d\\u092f\\u093e\\u0928\\u094d\\u0935\\u093f\\u0924 \\u0915\\u0930\\u0947\\u0902\\u0964 \\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0907\\u0928 \\u090f\\u091c\\u0947\\u0902\\u0938\\u093f\\u092f\\u094b\\u0902 \\u0914\\u0930 \\u0909\\u0928 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u092f\\u094b\\u0902 \\u092f\\u093e \\u0915\\u093e\\u0930\\u094d\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0938\\u0902\\u092c\\u0902\\u0927 \\u0938\\u0947 \\u0938\\u0902\\u0932\\u0917\\u094d\\u0928 \\u0939\\u0948 \\u091c\\u093f\\u0928\\u0915\\u093e \\u0909\\u0928\\u0915\\u0947 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093e\\u0927\\u093f\\u0915\\u094d\\u092f \\u0915\\u0947 \\u0905\\u0927\\u0940\\u0928 \\u0906\\u0928\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n\\r\\n<p>\\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915\\/\\u0935\\u093f\\u0928\\u093f\\u092f\\u093e\\u092e\\u0915 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u0947 \\u092a\\u094d\\u0930\\u092e\\u0941\\u0916 \\u0924\\u0924\\u094d\\u0935:<\\/p>\\r\\n\\r\\n<ol>\\r\\n    <li>\\r\\n        <p>\\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915 \\u090f\\u091c\\u0947\\u0902\\u0938\\u093f\\u092f\\u093e\\u0901: \\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915 \\u090f\\u091c\\u0947\\u0902\\u0938\\u093f\\u092f\\u093e\\u0901 \\u0935\\u093f\\u0927\\u093e\\u092f\\u0928\\u093f\\u0915\\u093f\\u092f\\u094b\\u0902 \\u092f\\u093e \\u0915\\u093e\\u0930\\u094d\\u092f\\u093e\\u0928\\u094d\\u0935\\u092f\\u0928 \\u0906\\u0926\\u0947\\u0936\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0938\\u094d\\u0925\\u093e\\u092a\\u093f\\u0924 \\u0915\\u0940 \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948\\u0902 \\u0924\\u093e\\u0915\\u093f \\u0938\\u0930\\u0915\\u093e\\u0930\\u0940 \\u0915\\u093e\\u0930\\u094d\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930\\u094b\\u0902 \\u0915\\u093e \\u092a\\u094d\\u0930\\u092c\\u0902\\u0927\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964 \\u092f\\u0947 \\u090f\\u091c\\u0947\\u0902\\u0938\\u093f\\u092f\\u093e\\u0901 \\u0938\\u0902\\u0918\\u0940\\u092f, \\u0930\\u093e\\u091c\\u094d\\u092f, \\u092f\\u093e \\u0938\\u094d\\u0925\\u093e\\u0928\\u0940\\u092f \\u0938\\u094d\\u0924\\u0930 \\u092a\\u0930 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0902 \\u0914\\u0930 \\u0909\\u0926\\u094d\\u092f\\u094b\\u0917\\u094b\\u0902 \\u0915\\u094b \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947, \\u0938\\u093e\\u0930\\u094d\\u0935\\u091c\\u0928\\u093f\\u0915 \\u0938\\u0947\\u0935\\u093e\\u0913\\u0902 \\u0915\\u093e \\u092a\\u0930\\u094d\\u092f\\u0935\\u0947\\u0915\\u094d\\u0937\\u0923 \\u0915\\u0930\\u0928\\u0947, \\u0932\\u093e\\u0907\\u0938\\u0947\\u0902\\u0938 \\u0926\\u0947\\u0928\\u0947 \\u0914\\u0930 \\u0915\\u093e\\u0928\\u0942\\u0928\\u094b\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u091c\\u0948\\u0938\\u0947 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u091c\\u093f\\u092e\\u094d\\u092e\\u0947\\u0926\\u093e\\u0930\\u093f\\u092f\\u093e\\u0901 \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0928\\u093f\\u092f\\u092e\\u0928: \\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915 \\u090f\\u091c\\u0947\\u0902\\u0938\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0915\\u093e\\u0930\\u094d\\u092f\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0938\\u0947 \\u090f\\u0915 \\u092f\\u0939 \\u0939\\u0948 \\u0915\\u093f \\u0935\\u0947 \\u0928\\u093f\\u092f\\u092e \\u0914\\u0930 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0918\\u094b\\u0937\\u0923\\u093e \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0947 \\u0928\\u093f\\u092f\\u092e \\u0924\\u0948\\u092f\\u093e\\u0930 \\u0915\\u093f\\u090f \\u091c\\u093e\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u0924\\u093e\\u0915\\u093f \\u0935\\u093f\\u0927\\u093e\\u092f\\u0928 \\u0938\\u0926\\u0928 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u092a\\u093e\\u0930\\u093f\\u0924 \\u0915\\u093f\\u090f \\u0917\\u090f \\u0915\\u093e\\u0928\\u0942\\u0928\\u094b\\u0902 \\u0915\\u094b \\u0915\\u0948\\u0938\\u0947 \\u0915\\u093e\\u0930\\u094d\\u092f\\u093e\\u0928\\u094d\\u0935\\u093f\\u0924 \\u0914\\u0930 \\u092a\\u094d\\u0930\\u0935\\u0930\\u094d\\u0924\\u093f\\u0924 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u090f, \\u0907\\u0938\\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u0935\\u093f\\u0935\\u0930\\u0923 \\u0914\\u0930 \\u092e\\u093e\\u0930\\u094d\\u0917\\u0926\\u0930\\u094d\\u0936\\u0928 \\u0915\\u0930\\u0947\\u0902\\u0964 \\u0928\\u093f\\u092f\\u092e\\u0928 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e\\u090f\\u0901 \\u0906\\u092e\\u0924\\u094c\\u0930 \\u092a\\u0930 \\u0938\\u093e\\u0930\\u094d\\u0935\\u091c\\u0928\\u093f\\u0915 \\u0938\\u0942\\u091a\\u0928\\u093e, \\u091f\\u093f\\u092a\\u094d\\u092a\\u0923\\u0940 \\u0905\\u0935\\u0927\\u093f\\u092f\\u093e\\u0901 \\u0914\\u0930 \\u0938\\u094d\\u092a\\u0937\\u094d\\u091f\\u0924\\u093e \\u0914\\u0930 \\u091c\\u0935\\u093e\\u092c\\u0926\\u0947\\u0939\\u0940 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915 \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0928\\u094d\\u092f\\u093e\\u092f\\u093f\\u0915 \\u0928\\u093f\\u0930\\u094d\\u0923\\u092f: \\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915 \\u090f\\u091c\\u0947\\u0902\\u0938\\u093f\\u092f\\u093e\\u090f\\u0901 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u0909\\u092a\\u0928\\u094d\\u092f\\u093e\\u0938\\u093f\\u0915 \\u0936\\u0915\\u094d\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0927\\u0930\\u0928\\u093e \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0902, \\u091c\\u094b \\u0909\\u0928\\u094d\\u0939\\u0947\\u0902 \\u092a\\u0915\\u094d\\u0937\\u094b\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0935\\u093f\\u0935\\u093e\\u0926\\u094b\\u0902 \\u0915\\u094b \\u0939\\u0932 \\u0915\\u0930\\u0928\\u0947 \\u092f\\u093e \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0905\\u0928\\u0941\\u092e\\u0924\\u093f \\u0926\\u0947\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u092e\\u0947\\u0902 \\u0924\\u0925\\u094d\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0924\\u092f \\u0915\\u0930\\u0928\\u0947, \\u0928\\u093f\\u092f\\u092e\\u094b\\u0902 \\u0915\\u093e \\u0935\\u094d\\u092f\\u093e\\u0916\\u094d\\u092f\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0914\\u0930 \\u090f\\u091c\\u0947\\u0902\\u0938\\u0940 \\u0915\\u0947 \\u0938\\u092e\\u0915\\u094d\\u0937 \\u0932\\u093e\\u090f \\u0917\\u090f \\u0935\\u093f\\u0936\\u0947\\u0937 \\u092e\\u093e\\u092e\\u0932\\u094b\\u0902 \\u092a\\u0930 \\u0928\\u093f\\u0930\\u094d\\u0923\\u092f \\u0926\\u0947\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915 \\u0938\\u0941\\u0928\\u0935\\u093e\\u0908 \\u0906\\u092f\\u094b\\u091c\\u093f\\u0924 \\u0915\\u0940 \\u091c\\u093e\\u0924\\u0940 \\u0939\\u0948\\u0964<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0928\\u094d\\u092f\\u093e\\u092f\\u093f\\u0915 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e: \\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915 \\u0928\\u093f\\u0930\\u094d\\u0923\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0928\\u094d\\u092f\\u093e\\u092f\\u093f\\u0915 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0938\\u092e\\u0930\\u094d\\u092a\\u093f\\u0924 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948 \\u0924\\u093e\\u0915\\u093f \\u092f\\u0939 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0939\\u094b \\u0915\\u093f \\u0935\\u0947 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u0914\\u0930 \\u0935\\u0947 \\u090f\\u091c\\u0947\\u0902\\u0938\\u0940 \\u0915\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u093f\\u0924\\u093e \\u0915\\u094b \\u092a\\u093e\\u0930 \\u0928\\u0939\\u0940\\u0902 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0928\\u094d\\u092f\\u093e\\u092f\\u093e\\u0932\\u092f \\u0935\\u0939 \\u090f\\u091c\\u0947\\u0902\\u0938\\u0940 \\u0915\\u0947 \\u0915\\u093e\\u0930\\u094d\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0909\\u0932\\u094d\\u0932\\u0902\\u0918\\u0928 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948 \\u091c\\u093f\\u0928\\u094d\\u0939\\u0947\\u0902 \\u0924\\u094d\\u092f\\u093e\\u0917\\u0940, \\u0909\\u0924\\u093e\\u0930 \\u091a\\u0922\\u093c\\u093e\\u0935 \\u092f\\u093e \\u0935\\u093f\\u0927\\u093f\\u0915 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0935\\u093f\\u0935\\u093e\\u0926\\u093e\\u0938\\u094d\\u092a\\u0926, \\u091a\\u093f\\u0902\\u0924\\u093e \\u0915\\u0940 \\u092c\\u093e\\u0924 \\u0915\\u0939\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0928\\u094d\\u092f\\u093e\\u092f\\u093f\\u0915 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e \\u0935\\u093f\\u0927\\u093e\\u092f\\u093f\\u0915\\u093e, \\u0915\\u093e\\u0930\\u094d\\u092f\\u0915\\u093e\\u0930\\u0940 \\u0914\\u0930 \\u0928\\u094d\\u092f\\u093e\\u092f\\u093f\\u0915 \\u0936\\u093e\\u0916\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0938\\u0902\\u0924\\u0941\\u0932\\u0928 \\u092c\\u0928\\u093e\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u092e\\u0926\\u0926 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0964<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u092f\\u094b\\u0917\\u094d\\u092f\\u0924\\u093e \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e: \\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915 \\u0915\\u094d\\u0930\\u093f\\u092f\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0924\\u0939\\u0924 \\u0906\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0914\\u0930 \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u094b\\u0902 \\u0915\\u094b \\u0909\\u0928\\u0915\\u0947 \\u0916\\u093f\\u0932\\u093e\\u092b \\u091a\\u093e\\u0930\\u094d\\u091c \\u092f\\u093e \\u0906\\u0930\\u094b\\u092a\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u0942\\u091a\\u0928\\u093e \\u0914\\u0930 \\u0928\\u093f\\u0937\\u094d\\u092a\\u0915\\u094d\\u0937 \\u0928\\u093f\\u0930\\u094d\\u0923\\u092f\\u0915\\u0930\\u094d\\u0924\\u093e \\u0915\\u0947 \\u0938\\u093e\\u092e\\u0928\\u0947 \\u0938\\u0941\\u0928\\u093e\\u0928\\u0947 \\u0915\\u093e \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930 \\u0939\\u0948\\u0964 \\u092f\\u094b\\u0917\\u094d\\u092f\\u0924\\u093e \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e\\u0913\\u0902 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u0917\\u0924 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0915\\u0940 \\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u092e\\u0926\\u0926 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948 \\u0914\\u0930 \\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915 \\u090f\\u091c\\u0947\\u0902\\u0938\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0935\\u093f\\u0935\\u093e\\u0926\\u093e\\u0938\\u094d\\u092a\\u0926 \\u0915\\u093e\\u0930\\u094d\\u0930\\u0935\\u093e\\u0908\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0930\\u094b\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0964<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0928\\u093f\\u0937\\u094d\\u092a\\u093e\\u0926\\u0928 \\u0914\\u0930 \\u0926\\u0923\\u094d\\u0921: \\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915 \\u090f\\u091c\\u0947\\u0902\\u0938\\u093f\\u092f\\u093e\\u090f\\u0901 \\u0905\\u092a\\u0928\\u0947 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0924\\u0930\\u0940\\u0915\\u094b\\u0902 \\u0938\\u0947 \\u0938\\u0915\\u094d\\u0937\\u092e \\u0939\\u0948\\u0902, \\u091c\\u093f\\u0938\\u092e\\u0947\\u0902 \\u0927\\u0928\\u0930\\u093e\\u0936\\u093f\\u092f\\u094b\\u0902, \\u091c\\u0941\\u0930\\u094d\\u092e\\u093e\\u0928\\u094b\\u0902, \\u0932\\u093e\\u0907\\u0938\\u0947\\u0902\\u0938 \\u0930\\u0926\\u094d\\u0926 \\u0915\\u0930\\u0928\\u0947 \\u0914\\u0930 \\u0905\\u0928\\u094d\\u092f \\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915 \\u0926\\u0923\\u094d\\u0921\\u094b\\u0902 \\u091c\\u0948\\u0938\\u0947 \\u0938\\u093e\\u0927\\u0928\\u0947 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0902\\u0964 \\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915 \\u0915\\u093e\\u0930\\u094d\\u0930\\u0935\\u093e\\u0908\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u093e \\u0914\\u0930 \\u0938\\u093e\\u0930\\u094d\\u0935\\u091c\\u0928\\u093f\\u0915 \\u0939\\u093f\\u0924 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0928\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0938\\u093e\\u0930\\u094d\\u0935\\u091c\\u0928\\u093f\\u0915 \\u092d\\u093e\\u0917\\u0940\\u0926\\u093e\\u0930\\u0940: \\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915 \\u090f\\u091c\\u0947\\u0902\\u0938\\u093f\\u092f\\u093e\\u090f\\u0901 \\u0906\\u092e\\u0924\\u094c\\u0930 \\u092a\\u0930 \\u0928\\u093f\\u092f\\u092e\\u0928 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u092e\\u0947\\u0902 \\u091c\\u0928\\u0924\\u093e \\u0915\\u0940 \\u0938\\u0939\\u092e\\u0924\\u093f \\u0914\\u0930 \\u092d\\u093e\\u0917\\u0940\\u0926\\u093e\\u0930\\u0940 \\u0916\\u094b\\u091c\\u0928\\u0947 \\u0915\\u093e \\u092a\\u094d\\u0930\\u092f\\u093e\\u0938 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0902, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0939\\u093f\\u0924\\u0927\\u093e\\u0930\\u0915\\u094b\\u0902 \\u0914\\u0930 \\u0938\\u093e\\u092e\\u093e\\u0928\\u094d\\u092f \\u091c\\u0928\\u0924\\u093e \\u0915\\u094b \\u0909\\u0928\\u0915\\u0940 \\u0930\\u093e\\u092f, \\u091a\\u093f\\u0902\\u0924\\u093e\\u0913\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u0936\\u0947\\u0937\\u091c\\u094d\\u091e\\u0924\\u093e \\u0915\\u094b \\u0938\\u0941\\u0928\\u093e\\u0928\\u0947 \\u0915\\u093e \\u0905\\u0935\\u0938\\u0930 \\u092e\\u093f\\u0932\\u0924\\u093e \\u0939\\u0948 \\u0938\\u0902\\u0915\\u0932\\u094d\\u092a\\u093f\\u0924 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u092a\\u0930\\u0964 \\u0938\\u093e\\u0930\\u094d\\u0935\\u091c\\u0928\\u093f\\u0915 \\u092d\\u093e\\u0917\\u0940\\u0926\\u093e\\u0930\\u0940 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0926\\u0943\\u0937\\u094d\\u091f\\u093f\\u0915\\u094b\\u0923\\u094b\\u0902 \\u0915\\u094b \\u0927\\u094d\\u092f\\u093e\\u0928 \\u092e\\u0947\\u0902 \\u0930\\u0916\\u0915\\u0930 \\u092a\\u094d\\u0930\\u092d\\u093e\\u0935\\u0940 \\u0914\\u0930 \\u0938\\u0902\\u0924\\u0941\\u0932\\u093f\\u0924 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0928\\u093f\\u0930\\u094d\\u092e\\u093e\\u0923 \\u0915\\u0930\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u092e\\u0926\\u0926 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0964<\\/p>\\r\\n    <\\/li>\\r\\n<\\/ol>\\r\\n\\r\\n<p>\\u0915\\u0941\\u0932 \\u092e\\u093f\\u0932\\u093e\\u0915\\u0930, \\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915\\/\\u0935\\u093f\\u0928\\u093f\\u092f\\u093e\\u092e\\u0915 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0938\\u0930\\u0915\\u093e\\u0930\\u0940 \\u0928\\u0940\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0930\\u0942\\u092a\\u093e\\u0902\\u0924\\u0930\\u093f\\u0924 \\u0914\\u0930 \\u0915\\u093e\\u0930\\u094d\\u0930\\u0935\\u093e\\u0908 \\u0915\\u0930\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092d\\u0942\\u092e\\u093f\\u0915\\u093e \\u0928\\u093f\\u092d\\u093e\\u0924\\u093e \\u0939\\u0948, \\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915 \\u090f\\u091c\\u0947\\u0902\\u0938\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0926\\u0915\\u094d\\u0937 \\u0915\\u093e\\u0930\\u094d\\u092f\\u093e\\u0928\\u094d\\u0935\\u092f\\u0928 \\u0915\\u0940 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924\\u093f \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u0914\\u0930 \\u0909\\u0928 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0914\\u0930 \\u0915\\u093e\\u0930\\u094d\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0914\\u0930 \\u0939\\u093f\\u0924\\u094b\\u0902 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u091c\\u093f\\u0928\\u094d\\u0939\\u0947\\u0902 \\u0909\\u0928\\u0915\\u0947 \\u0915\\u093e\\u0930\\u094d\\u092f\\u094b\\u0902 \\u0938\\u0947 \\u092a\\u094d\\u0930\\u092d\\u093e\\u0935\\u093f\\u0924 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>","ar":"<p>\\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u064a\\u060c \\u0627\\u0644\\u0645\\u0639\\u0631\\u0648\\u0641 \\u0623\\u064a\\u0636\\u0627\\u064b \\u0628\\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u064a\\u060c \\u0647\\u0648 \\u0641\\u0631\\u0639 \\u0645\\u0646 \\u0641\\u0631\\u0648\\u0639 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u064a\\u062d\\u0643\\u0645 \\u062a\\u0646\\u0638\\u064a\\u0645 \\u0648\\u0635\\u0644\\u0627\\u062d\\u064a\\u0627\\u062a \\u0648\\u0625\\u062c\\u0631\\u0627\\u0621\\u0627\\u062a \\u0648\\u0648\\u0638\\u0627\\u0626\\u0641 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u064a\\u0629. \\u062a\\u062a\\u0645 \\u0625\\u0646\\u0634\\u0627\\u0621 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u0645\\u0646 \\u0642\\u0628\\u0644 \\u0627\\u0644\\u062d\\u0643\\u0648\\u0645\\u0627\\u062a \\u0644\\u062a\\u0646\\u0641\\u064a\\u0630 \\u0645\\u0647\\u0627\\u0645 \\u0645\\u062d\\u062f\\u062f\\u0629\\u060c \\u0648\\u0641\\u0631\\u0636 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646\\u060c \\u0648\\u062a\\u0646\\u0641\\u064a\\u0630 \\u0627\\u0644\\u0633\\u064a\\u0627\\u0633\\u0627\\u062a \\u0641\\u064a \\u0645\\u062c\\u0627\\u0644\\u0627\\u062a \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u062a\\u0647\\u0645 \\u0627\\u0644\\u0631\\u0623\\u064a \\u0627\\u0644\\u0639\\u0627\\u0645. \\u064a\\u062a\\u0646\\u0627\\u0648\\u0644 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u064a \\u0627\\u0644\\u0639\\u0644\\u0627\\u0642\\u0629 \\u0628\\u064a\\u0646 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u0648\\u0627\\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0623\\u0648 \\u0627\\u0644\\u0643\\u064a\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u062a\\u062e\\u0636\\u0639 \\u0644\\u0648\\u0644\\u0627\\u064a\\u062a\\u0647\\u0627.<\\/p>\\r\\n\\r\\n<p>\\u0627\\u0644\\u0639\\u0646\\u0627\\u0635\\u0631 \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0644\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u064a\\/\\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u064a:<\\/p>\\r\\n\\r\\n<ol>\\r\\n    <li>\\r\\n        <p>\\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u064a\\u0629: \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u064a\\u0629 \\u0647\\u064a \\u0647\\u064a\\u0626\\u0627\\u062a \\u062a\\u0623\\u0633\\u0633\\u062a \\u0645\\u0646 \\u0642\\u0628\\u0644 \\u0627\\u0644\\u0628\\u0631\\u0644\\u0645\\u0627\\u0646\\u0627\\u062a \\u0623\\u0648 \\u0627\\u0644\\u0623\\u0648\\u0627\\u0645\\u0631 \\u0627\\u0644\\u062a\\u0646\\u0641\\u064a\\u0630\\u064a\\u0629 \\u0644\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0645\\u062c\\u0627\\u0644\\u0627\\u062a \\u0645\\u062d\\u062f\\u062f\\u0629 \\u0645\\u0646 \\u0648\\u0638\\u0627\\u0626\\u0641 \\u0627\\u0644\\u062d\\u0643\\u0648\\u0645\\u0629. \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u0643\\u0648\\u0646 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u0639\\u0644\\u0649 \\u0645\\u0633\\u062a\\u0648\\u0649 \\u0627\\u0644\\u0627\\u062a\\u062d\\u0627\\u062f\\u064a\\u0629\\u060c \\u0627\\u0644\\u0648\\u0644\\u0627\\u0626\\u064a\\u0629\\u060c \\u0623\\u0648 \\u0627\\u0644\\u0645\\u062d\\u0644\\u064a\\u0629 \\u0648\\u0644\\u0647\\u0627 \\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0627\\u062a \\u0645\\u062a\\u0646\\u0648\\u0639\\u0629\\u060c \\u0645\\u062b\\u0644 \\u062a\\u0646\\u0638\\u064a\\u0645 \\u0627\\u0644\\u0635\\u0646\\u0627\\u0639\\u0627\\u062a\\u060c \\u0648\\u0627\\u0644\\u0625\\u0634\\u0631\\u0627\\u0641 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0639\\u0627\\u0645\\u0629\\u060c \\u0648\\u0645\\u0646\\u062d \\u0627\\u0644\\u062a\\u0631\\u0627\\u062e\\u064a\\u0635\\u060c \\u0648\\u0636\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0644\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0644\\u0648\\u0627\\u0626\\u062d.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f: \\u0625\\u062d\\u062f\\u0649 \\u0627\\u0644\\u0648\\u0638\\u0627\\u0626\\u0641 \\u0627\\u0644\\u0623\\u0633\\u0627\\u0633\\u064a\\u0629 \\u0644\\u0644\\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u064a\\u0629 \\u0647\\u0648 \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f \\u0648\\u0627\\u0644\\u0644\\u0648\\u0627\\u0626\\u062d. \\u064a\\u062a\\u0645 \\u0635\\u064a\\u0627\\u063a\\u0629 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f \\u0644\\u062a\\u0648\\u0641\\u064a\\u0631 \\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0648\\u0627\\u0644\\u0625\\u0631\\u0634\\u0627\\u062f\\u0627\\u062a \\u062d\\u0648\\u0644 \\u0643\\u064a\\u0641\\u064a\\u0629 \\u062a\\u0646\\u0641\\u064a\\u0630 \\u0648\\u0641\\u0631\\u0636 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u062a\\u064a \\u0623\\u0642\\u0631\\u0647\\u0627 \\u0627\\u0644\\u0628\\u0631\\u0644\\u0645\\u0627\\u0646. \\u062a\\u062a\\u0636\\u0645\\u0646 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0625\\u0635\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f \\u0639\\u0627\\u062f\\u0629\\u064b \\u0625\\u0634\\u0639\\u0627\\u0631\\u064b\\u0627 \\u0639\\u0627\\u0645\\u064b\\u0627 \\u0648\\u0641\\u062a\\u0631\\u0627\\u062a \\u062a\\u0639\\u0644\\u064a\\u0642 \\u0648\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f \\u0631\\u0633\\u0645\\u064a\\u0629 \\u0644\\u0636\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0634\\u0641\\u0627\\u0641\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0645\\u0633\\u0627\\u0621\\u0644\\u0629.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629: \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u064a\\u0629 \\u063a\\u0627\\u0644\\u0628\\u0627\\u064b \\u0645\\u0627 \\u062a\\u0645\\u062a\\u0644\\u0643 \\u0635\\u0644\\u0627\\u062d\\u064a\\u0627\\u062a \\u0646\\u0635\\u0641 \\u0642\\u0636\\u0627\\u0626\\u064a\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u062a\\u064a\\u062d \\u0644\\u0647\\u0627 \\u062d\\u0644 \\u0627\\u0644\\u0646\\u0632\\u0627\\u0639\\u0627\\u062a \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u0623\\u0648 \\u0641\\u0631\\u0636 \\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0644\\u0644\\u0648\\u0627\\u0626\\u062d. \\u064a\\u064f\\u062c\\u0631\\u0649 \\u062c\\u0644\\u0633\\u0627\\u062a \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u064a\\u0629 \\u0644\\u062a\\u062d\\u062f\\u064a\\u062f \\u0627\\u0644\\u062d\\u0642\\u0627\\u0626\\u0642\\u060c \\u0648\\u062a\\u0641\\u0633\\u064a\\u0631 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f\\u060c \\u0648\\u0627\\u062a\\u062e\\u0627\\u0630 \\u0627\\u0644\\u0642\\u0631\\u0627\\u0631\\u0627\\u062a \\u0641\\u064a \\u0627\\u0644\\u062d\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0627\\u0644\\u062a\\u064a \\u064a\\u062a\\u0645 \\u062a\\u0642\\u062f\\u064a\\u0645\\u0647\\u0627 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0629.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0627\\u0644\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0627\\u0644\\u0642\\u0636\\u0627\\u0626\\u064a\\u0629: \\u064a\\u064f\\u062e\\u0636\\u0639 \\u0627\\u0644\\u0642\\u0631\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0627\\u0644\\u0642\\u0636\\u0627\\u0626\\u064a\\u0629 \\u0644\\u0636\\u0645\\u0627\\u0646 \\u0623\\u0646\\u0647\\u0627 \\u062a\\u062a\\u0648\\u0627\\u0641\\u0642 \\u0645\\u0639 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0648\\u0623\\u0646\\u0647\\u0627 \\u0644\\u0627 \\u062a\\u062a\\u062c\\u0627\\u0648\\u0632 \\u0633\\u0644\\u0637\\u0629 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0629. \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u0645\\u062d\\u0627\\u0643\\u0645 \\u0625\\u0644\\u063a\\u0627\\u0621 \\u0625\\u062c\\u0631\\u0627\\u0621\\u0627\\u062a \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0629 \\u0627\\u0644\\u062a\\u064a \\u064a\\u0639\\u062a\\u0628\\u0631\\u0647\\u0627 \\u062a\\u0639\\u0633\\u0641\\u064a\\u0629 \\u0623\\u0648 \\u062a\\u0642\\u0644\\u064a\\u062f\\u064a\\u0629 \\u0623\\u0648 \\u0645\\u062e\\u0627\\u0644\\u0641\\u0629 \\u0644\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646. \\u062a\\u0648\\u0641\\u0631 \\u0627\\u0644\\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0627\\u0644\\u0642\\u0636\\u0627\\u0626\\u064a\\u0629 \\u0641\\u062d\\u0635\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0645\\u0645\\u0627\\u0631\\u0633\\u0629 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u0644\\u0644\\u0633\\u0644\\u0637\\u0629 \\u0648\\u062a\\u0633\\u0627\\u0639\\u062f \\u0641\\u064a \\u0627\\u0644\\u062d\\u0641\\u0627\\u0638 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0632\\u0646 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0633\\u0644\\u0637\\u0627\\u062a \\u0627\\u0644\\u062a\\u0646\\u0641\\u064a\\u0630\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062a\\u0634\\u0631\\u064a\\u0639\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0642\\u0636\\u0627\\u0626\\u064a\\u0629 \\u0644\\u0644\\u062d\\u0643\\u0648\\u0645\\u0629.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0627\\u0644\\u0625\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a: \\u0627\\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0648\\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u062e\\u0627\\u0636\\u0639\\u0629 \\u0644\\u0625\\u062c\\u0631\\u0627\\u0621\\u0627\\u062a \\u0625\\u062f\\u0627\\u0631\\u064a\\u0629 \\u0644\\u062f\\u064a\\u0647\\u0645 \\u0627\\u0644\\u062d\\u0642 \\u0641\\u064a \\u0627\\u0644\\u0625\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u060c \\u0648\\u0627\\u0644\\u0630\\u064a \\u064a\\u062a\\u0636\\u0645\\u0646 \\u0625\\u0634\\u0639\\u0627\\u0631\\u064b\\u0627 \\u0628\\u0627\\u0644\\u062a\\u0647\\u0645 \\u0623\\u0648 \\u0627\\u0644\\u0627\\u062a\\u0647\\u0627\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u0648\\u062c\\u0647\\u0629 \\u0625\\u0644\\u064a\\u0647\\u0645 \\u0648\\u0641\\u0631\\u0635\\u0629 \\u0644\\u0644\\u0645\\u062b\\u0648\\u0644 \\u0623\\u0645\\u0627\\u0645 \\u0645\\u0635\\u0645\\u0645 \\u0642\\u0627\\u0636\\u064a \\u0645\\u062d\\u0627\\u064a\\u062f. \\u062a\\u0633\\u0627\\u0639\\u062f \\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0625\\u062c\\u0631\\u0627\\u0621\\u0627\\u062a \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0641\\u064a \\u062d\\u0645\\u0627\\u064a\\u0629 \\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u0641\\u0631\\u062f \\u0648\\u0645\\u0646\\u0639 \\u0627\\u0644\\u0625\\u062c\\u0631\\u0627\\u0621\\u0627\\u062a \\u0627\\u0644\\u062a\\u0639\\u0633\\u0641\\u064a\\u0629 \\u0645\\u0646 \\u0642\\u0628\\u0644 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u064a\\u0629.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0627\\u0644\\u062a\\u0646\\u0641\\u064a\\u0630 \\u0648\\u0627\\u0644\\u0639\\u0642\\u0648\\u0628\\u0627\\u062a: \\u062a\\u062a\\u0645\\u062a\\u0639 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u064a\\u0629 \\u0628\\u0627\\u0644\\u0633\\u0644\\u0637\\u0629 \\u0644\\u0641\\u0631\\u0636 \\u0642\\u0648\\u0627\\u0646\\u064a\\u0646\\u0647\\u0627 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0648\\u0633\\u0627\\u0626\\u0644 \\u0645\\u062a\\u0646\\u0648\\u0639\\u0629\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0627\\u0644\\u063a\\u0631\\u0627\\u0645\\u0627\\u062a \\u0648\\u0627\\u0644\\u0639\\u0642\\u0648\\u0628\\u0627\\u062a \\u0648\\u0633\\u062d\\u0628 \\u0627\\u0644\\u062a\\u0631\\u0627\\u062e\\u064a\\u0635 \\u0648\\u0639\\u0642\\u0648\\u0628\\u0627\\u062a \\u0623\\u062e\\u0631\\u0649 \\u0625\\u062f\\u0627\\u0631\\u064a\\u0629. \\u062a\\u0647\\u062f\\u0641 \\u0625\\u062c\\u0631\\u0627\\u0621\\u0627\\u062a \\u0627\\u0644\\u062a\\u0646\\u0641\\u064a\\u0630 \\u0625\\u0644\\u0649 \\u0636\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0644\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0648\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0635\\u0644\\u062d\\u0629 \\u0627\\u0644\\u0639\\u0627\\u0645\\u0629.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0627\\u0644\\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0627\\u0644\\u0639\\u0627\\u0645\\u0629: \\u063a\\u0627\\u0644\\u0628\\u064b\\u0627 \\u0645\\u0627 \\u062a\\u0633\\u0639\\u0649 \\u0627\\u0644\\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u064a\\u0629 \\u0625\\u0644\\u0649 \\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0627\\u0644\\u062c\\u0645\\u0647\\u0648\\u0631 \\u0648\\u0627\\u0644\\u0645\\u062f\\u0627\\u062e\\u0644\\u0629 \\u0641\\u064a \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0635\\u064a\\u0627\\u063a\\u0629 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f\\u060c \\u0645\\u0645\\u0627 \\u064a\\u062a\\u064a\\u062d \\u0644\\u0644\\u0645\\u0639\\u0646\\u064a\\u064a\\u0646 \\u0648\\u0627\\u0644\\u062c\\u0645\\u0647\\u0648\\u0631 \\u0627\\u0644\\u0639\\u0627\\u0645 \\u0627\\u0644\\u062a\\u0639\\u0628\\u064a\\u0631 \\u0639\\u0646 \\u0622\\u0631\\u0627\\u0626\\u0647\\u0645 \\u0648\\u0627\\u0647\\u062a\\u0645\\u0627\\u0645\\u0627\\u062a\\u0647\\u0645 \\u0648\\u062e\\u0628\\u0631\\u0627\\u062a\\u0647\\u0645 \\u0641\\u064a \\u0627\\u0644\\u0642\\u0648\\u0627\\u0639\\u062f \\u0627\\u0644\\u0645\\u0642\\u062a\\u0631\\u062d\\u0629. \\u062a\\u0639\\u062a\\u0628\\u0631 \\u0627\\u0644\\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0627\\u0644\\u0639\\u0627\\u0645\\u0629 \\u0623\\u0645\\u0631\\u064b\\u0627 \\u062d\\u0627\\u0633\\u0645\\u064b\\u0627 \\u0641\\u064a \\u0635\\u064a\\u0627\\u063a\\u0629 \\u0642\\u0648\\u0627\\u0639\\u062f \\u0641\\u0639\\u0627\\u0644\\u0629 \\u0648\\u0645\\u062a\\u0648\\u0627\\u0632\\u0646\\u0629 \\u062a\\u0623\\u062e\\u0630 \\u0641\\u064a \\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0647\\u0627 \\u0648\\u062c\\u0647\\u0627\\u062a \\u0646\\u0638\\u0631 \\u0645\\u062a\\u0646\\u0648\\u0639\\u0629.<\\/p>\\r\\n    <\\/li>\\r\\n<\\/ol>\\r\\n\\r\\n<p>\\u0628\\u0634\\u0643\\u0644 \\u0639\\u0627\\u0645\\u060c \\u064a\\u0644\\u0639\\u0628 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u064a\\/\\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u064a \\u062f\\u0648\\u0631\\u0627\\u064b \\u062d\\u0627\\u0633\\u0645\\u0627\\u064b \\u0641\\u064a \\u062a\\u0634\\u0643\\u064a\\u0644 \\u0648\\u062a\\u0646\\u0641\\u064a\\u0630 \\u0627\\u0644\\u0633\\u064a\\u0627\\u0633\\u0627\\u062a \\u0627\\u0644\\u062d\\u0643\\u0648\\u0645\\u064a\\u0629\\u060c \\u0648\\u0636\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0639\\u0645\\u0644 \\u0627\\u0644\\u0641\\u0639\\u0627\\u0644 \\u0644\\u0644\\u0648\\u0643\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u064a\\u0629\\u060c \\u0648\\u062d\\u0645\\u0627\\u064a\\u0629 \\u062d\\u0642\\u0648\\u0642 \\u0648\\u0645\\u0635\\u0627\\u0644\\u062d \\u0627\\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0648\\u0627\\u0644\\u0643\\u064a\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u0623\\u062b\\u0631\\u0629 \\u0628\\u0623\\u0641\\u0639\\u0627\\u0644\\u0647\\u0627.<\\/p>"}',
                'icon' => '/images/therapist_main_categories/64cb8679f3919.png',
                'id' => 1,
                'image' => '/images/therapist_main_categories/64cb8679f3032.png',
                'is_active' => 1,
                'is_featured' => 1,
                'name' => '{"en":"Administrative \\/ Regulatory Therapy","hi":"\\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0928\\u093f\\u0915\\/\\u0935\\u093f\\u0928\\u093f\\u092f\\u093e\\u092e\\u0915 \\u0915\\u093e\\u0928\\u0942\\u0928","ar":"\\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u064a \\/ \\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u064a"}',
                'slug' => 'parashasanakavanayamaka-kanana-1',
                'updated_at' => '2023-10-10 18:42:07',
            ),
            1 => 
            array (
                'created_at' => '2023-08-03 12:40:34',
                'deleted_at' => NULL,
            'description' => '{"en":"<p>Cannabis Therapy refers to the legal framework that governs the cultivation, possession, distribution, sale, and use of cannabis, commonly known as marijuana or weed. Over the years, attitudes and regulations surrounding cannabis have evolved significantly, leading to a complex and dynamic legal landscape in various jurisdictions worldwide. The content of cannabis therapy typically covers the following key aspects:<\\/p>\\r\\n\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p>Cannabis Legalization: Some countries and states have chosen to legalize cannabis for medicinal and\\/or recreational purposes. Legalization often involves setting up a regulatory system to control and oversee the production, distribution, and sale of cannabis products. These therapys define who can participate in the cannabis industry, licensing requirements, and product safety standards.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Medical Cannabis: Many jurisdictions have recognized the therapeutic potential of cannabis and have established legal frameworks for medical cannabis use. Medical cannabis therapys typically require patients to obtain a medical recommendation or prescription from a licensed healthcare provider to access cannabis products for specific medical conditions.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Recreational Use: In regions where recreational cannabis is legal, individuals over a certain age can purchase and possess cannabis products for personal use. Legalization for recreational use may come with restrictions on the quantity individuals can possess, where they can consume it, and regulations to ensure public safety.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Licensing and Regulation: Cannabis therapy often dictates the licensing process for businesses involved in cannabis cultivation, processing, distribution, and retail. Regulations cover issues such as security requirements, quality control, advertising restrictions, taxation, and zoning therapys for cannabis-related businesses.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Public Health and Safety: Cannabis therapys address public health and safety concerns related to cannabis use. They may set limits on THC potency, impose restrictions on advertising, require product testing and labeling, and outline penalties for impaired driving.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Industrial Hemp: Many countries have differentiated between cannabis with high THC content (marijuana) and cannabis with low THC content (industrial hemp). Therapys related to industrial hemp govern its cultivation, processing, and use for various industrial purposes, such as fiber, textiles, and CBD production.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Federal vs. State\\/Provincial Therapys: In some countries, cannabis therapys can vary significantly between federal and regional levels of government. While federal therapy may classify cannabis as a controlled substance, individual states or provinces may choose to implement their own regulations, including legalization for medical or recreational use.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>International Cannabis Therapys: The global legality of cannabis varies from country to country, and international treaties, such as the Single Convention on Narcotic Drugs, influence how countries approach cannabis control. Some countries may face challenges due to conflicting international and domestic cannabis therapys.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Decriminalization: In some jurisdictions, cannabis use may be decriminalized, meaning that possession of small amounts is treated as a civil offense rather than a criminal one. Decriminalization aims to reduce the burden on the criminal justice system while not fully legalizing cannabis.<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n\\r\\n<p>Cannabis therapy is continually evolving as attitudes toward cannabis change, scientific research progresses, and societies grapple with issues of public health, criminal justice, and economic considerations. It&#39;s important for individuals and businesses operating within the cannabis industry or considering cannabis use to stay informed about the specific therapys and regulations in their region to ensure compliance and avoid legal repercussions.<\\/p>","hi":"<p>\\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0909\\u0938 \\u0935\\u0948\\u0927\\u093f\\u0915 \\u0928\\u093f\\u0930\\u094d\\u0926\\u0947\\u0936\\u093f\\u0915\\u093e \\u0915\\u094b \\u0938\\u0902\\u0926\\u0930\\u094d\\u092d\\u093f\\u0924 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u091c\\u093f\\u0938\\u0938\\u0947 \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0915\\u0947 \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926\\u0928, \\u0938\\u0902\\u0918\\u091f\\u0928, \\u0935\\u093f\\u0924\\u0930\\u0923, \\u092c\\u0947\\u091a\\u0928\\u0947 \\u0914\\u0930 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u093e \\u0935\\u093f\\u0927\\u093e\\u0928 \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0947 \\u0938\\u093e\\u092e\\u093e\\u0928\\u094d\\u092f\\u0924: \\u092e\\u093e\\u0930\\u093f\\u091c\\u0941\\u0906\\u0928\\u093e \\u092f\\u093e \\u092c\\u0940\\u0921 \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u091c\\u093e\\u0928\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0935\\u0930\\u094d\\u0937\\u094b\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u0924\\u0928\\u0947 \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0915\\u0947 \\u091a\\u093e\\u0930\\u094b\\u0902 \\u0913\\u0930 \\u0926\\u0943\\u0937\\u094d\\u091f\\u093f\\u0915\\u094b\\u0923 \\u0914\\u0930 \\u0935\\u093f\\u0927\\u093f \\u0928\\u093f\\u092f\\u093e\\u092e\\u0915 \\u092a\\u0930\\u093f\\u092f\\u094b\\u091c\\u0928\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0928\\u093f\\u092f\\u092e\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0914\\u0930 \\u0917\\u0924\\u093f\\u0936\\u0940\\u0932 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0938\\u0902\\u0930\\u091a\\u0928\\u093e \\u0915\\u0947 \\u092c\\u0926\\u0932\\u093e\\u0935 \\u0939\\u0941\\u090f \\u0939\\u0948\\u0902 \\u0935\\u093f\\u0936\\u094d\\u0935\\u092d\\u0930 \\u092e\\u0947\\u0902 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930\\u094b\\u0902 \\u092e\\u0947\\u0902\\u0964 \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0915\\u0940 \\u0938\\u093e\\u092e\\u0917\\u094d\\u0930\\u0940 \\u0906\\u092e\\u0924\\u094c\\u0930 \\u092a\\u0930 \\u0928\\u093f\\u092e\\u094d\\u0928\\u0932\\u093f\\u0916\\u093f\\u0924 \\u092a\\u094d\\u0930\\u092e\\u0941\\u0916 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u092a\\u0930 \\u0935\\u093f\\u091a\\u093e\\u0930 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948:<\\/p>\\r\\n\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0935\\u093f\\u0927\\u093e\\u0928: \\u0915\\u0941\\u091b \\u0926\\u0947\\u0936\\u094b\\u0902 \\u0914\\u0930 \\u0930\\u093e\\u091c\\u094d\\u092f\\u094b\\u0902 \\u0928\\u0947 \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0915\\u094b \\u091a\\u093f\\u0915\\u093f\\u0924\\u094d\\u0938\\u093e \\u0914\\u0930\\/\\u092f\\u093e \\u092e\\u0928\\u094b\\u0930\\u0902\\u091c\\u0928\\u093f\\u0915 \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0935\\u0948\\u0927 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u093e \\u091a\\u092f\\u0928 \\u0915\\u093f\\u092f\\u093e \\u0939\\u0948\\u0964 \\u0935\\u0948\\u0927\\u0940\\u0915\\u0930\\u0923 \\u0906\\u092e\\u0924\\u094c\\u0930 \\u092a\\u0930 \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926\\u094b\\u0902 \\u0915\\u0947 \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926\\u0928, \\u0935\\u093f\\u0924\\u0930\\u0923, \\u0914\\u0930 \\u092c\\u093f\\u0915\\u094d\\u0930\\u0940 \\u0915\\u094b \\u0928\\u093f\\u092f\\u0902\\u0924\\u094d\\u0930\\u093f\\u0924 \\u0914\\u0930 \\u092a\\u0930\\u094d\\u092f\\u0935\\u0947\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u090f\\u0915 \\u0935\\u093f\\u0928\\u093f\\u092f\\u093e\\u092e\\u0915 \\u0924\\u0902\\u0924\\u094d\\u0930 \\u0915\\u0940 \\u0938\\u094d\\u0925\\u093e\\u092a\\u0928\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u094b \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0947 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0947\\u0902 \\u092f\\u0939 \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0902 \\u0915\\u093f \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0909\\u0926\\u094d\\u092f\\u094b\\u0917 \\u092e\\u0947\\u0902 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0932\\u093e\\u0907\\u0938\\u0947\\u0902\\u0938 \\u092a\\u094d\\u0930\\u093e\\u0930\\u0902\\u092d \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e\\u090f\\u0901, \\u0914\\u0930 \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u092e\\u093e\\u0928\\u0915\\u094b\\u0902 \\u0915\\u094b\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u091a\\u093f\\u0915\\u093f\\u0924\\u094d\\u0938\\u093e \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938: \\u0915\\u0908 \\u092a\\u0930\\u093f\\u092f\\u094b\\u091c\\u0928\\u093e\\u0913\\u0902 \\u0928\\u0947 \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0915\\u0947 \\u0914\\u0937\\u0927\\u0940\\u092f \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0940 \\u0914\\u0937\\u0927\\u093f\\u0915 \\u0917\\u0941\\u0923\\u094b\\u0902 \\u0915\\u094b \\u092e\\u093e\\u0928\\u094d\\u092f\\u0924\\u093e \\u0926\\u0940 \\u0939\\u0948 \\u0914\\u0930 \\u091a\\u093f\\u0915\\u093f\\u0924\\u094d\\u0938\\u093e \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0935\\u0948\\u0927\\u093f\\u0915 \\u0928\\u093f\\u0930\\u094d\\u0926\\u0947\\u0936\\u093f\\u0915\\u093e \\u0938\\u094d\\u0925\\u093e\\u092a\\u093f\\u0924 \\u0915\\u0940 \\u0939\\u0948\\u0964 \\u091a\\u093f\\u0915\\u093f\\u0924\\u094d\\u0938\\u093e \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0915\\u093e\\u0928\\u0942\\u0928\\u094b\\u0902 \\u0915\\u0940 \\u0906\\u092e\\u0924\\u094c\\u0930 \\u092a\\u0930 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e \\u0939\\u0948 \\u0915\\u093f \\u0930\\u094b\\u0917\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0915\\u093f\\u0938\\u0940 \\u092a\\u094d\\u0930\\u093e\\u0927\\u093f\\u0915\\u0943\\u0924 \\u0938\\u094d\\u0935\\u093e\\u0938\\u094d\\u0925\\u094d\\u092f \\u0938\\u0947\\u0935\\u093e \\u092a\\u094d\\u0930\\u0926\\u093e\\u0924\\u093e \\u0938\\u0947 \\u091a\\u093f\\u0915\\u093f\\u0924\\u094d\\u0938\\u093e \\u0938\\u093f\\u092b\\u093e\\u0930\\u093f\\u0936 \\u092f\\u093e \\u0926\\u0935\\u093e \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u090f\\u0915 \\u091a\\u093f\\u0915\\u093f\\u0924\\u094d\\u0938\\u093e \\u0938\\u093f\\u092b\\u093e\\u0930\\u093f\\u0936 \\u092f\\u093e \\u0926\\u0935\\u093e \\u0915\\u0940 \\u091c\\u0930\\u0941\\u0930\\u0924 \\u0939\\u094b\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u092e\\u0928\\u094b\\u0930\\u0902\\u091c\\u0928\\u093f\\u0915 \\u0909\\u092a\\u092f\\u094b\\u0917: \\u0909\\u0928 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u091c\\u0939\\u093e\\u0902 \\u092e\\u0928\\u094b\\u0930\\u0902\\u091c\\u0928\\u093f\\u0915 \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0935\\u0948\\u0927 \\u0939\\u0948, \\u0935\\u0939\\u093e\\u0901 \\u0935\\u093f\\u0936\\u093f\\u0937\\u094d\\u091f \\u0906\\u092f\\u0941 \\u0938\\u0947 \\u0905\\u0927\\u093f\\u0915 \\u0909\\u092e\\u094d\\u0930 \\u0915\\u0947 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926\\u094b\\u0902 \\u0915\\u094b \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u0917\\u0924 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0916\\u0930\\u0940\\u0926 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u0914\\u0930 \\u0909\\u0928\\u0915\\u0947 \\u092a\\u093e\\u0938 \\u0930\\u0916 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0907\\u0938\\u094d\\u0924\\u0947\\u092e\\u093e\\u0932 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0935\\u0948\\u0927\\u0940\\u0915\\u0930\\u0923 \\u0906\\u092e\\u0924\\u094c\\u0930 \\u092a\\u0930 \\u0909\\u0928\\u0915\\u0940 \\u0938\\u0902\\u092a\\u0924\\u094d\\u0924\\u093f \\u0915\\u093f\\u0924\\u0928\\u0940 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948, \\u0935\\u0947 \\u0915\\u0939\\u093e\\u0902 \\u0907\\u0938\\u094d\\u0924\\u0947\\u092e\\u093e\\u0932 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0914\\u0930 \\u0938\\u093e\\u0930\\u094d\\u0935\\u091c\\u0928\\u093f\\u0915 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0928\\u093f\\u092f\\u092e\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u0906 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u0932\\u093e\\u0907\\u0938\\u0947\\u0902\\u0938 \\u0914\\u0930 \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928: \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0905\\u0915\\u094d\\u0938\\u0930 \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926\\u0928, \\u092a\\u094d\\u0930\\u0938\\u0902\\u0938\\u094d\\u0915\\u0930\\u0923, \\u0935\\u093f\\u0924\\u0930\\u0923, \\u0914\\u0930 \\u0916\\u0941\\u0926\\u0930\\u093e \\u092e\\u0947\\u0902 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0935\\u094d\\u092f\\u0935\\u0938\\u093e\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0932\\u093e\\u0907\\u0938\\u0947\\u0902\\u0938\\u093f\\u0902\\u0917 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u094b \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928 \\u0938\\u0902\\u0930\\u0915\\u094d\\u0937\\u0923, \\u0917\\u0941\\u0923\\u0935\\u0924\\u094d\\u0924\\u093e \\u0928\\u093f\\u092f\\u0902\\u0924\\u094d\\u0930\\u0923, \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928 \\u092a\\u094d\\u0930\\u0924\\u093f\\u092c\\u0902\\u0927\\u0928, \\u0915\\u0930 \\u0932\\u0917\\u093e\\u0928\\u0947 \\u0915\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e, \\u0914\\u0930 \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0938\\u0902\\u092c\\u0902\\u0927\\u0940 \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930\\u0935\\u093e\\u0930 \\u0928\\u093f\\u092f\\u092e\\u094b\\u0902 \\u091c\\u0948\\u0938\\u0947 \\u092e\\u0941\\u0926\\u094d\\u0926\\u094b\\u0902 \\u0915\\u094b \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u0938\\u093e\\u0930\\u094d\\u0935\\u091c\\u0928\\u093f\\u0915 \\u0938\\u094d\\u0935\\u093e\\u0938\\u094d\\u0925\\u094d\\u092f \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e: \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0947 \\u0938\\u092e\\u092f \\u0938\\u093e\\u0930\\u094d\\u0935\\u091c\\u0928\\u093f\\u0915 \\u0938\\u094d\\u0935\\u093e\\u0938\\u094d\\u0925\\u094d\\u092f \\u0914\\u0930 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0938\\u092e\\u094d\\u092c\\u0902\\u0927\\u093f\\u0924 \\u091a\\u093f\\u0902\\u0924\\u093e\\u0913\\u0902 \\u092a\\u0930 \\u0935\\u093f\\u091a\\u093e\\u0930 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0907\\u0928\\u094d\\u0939\\u0947\\u0902 \\u0906\\u092e\\u0924\\u094c\\u0930 \\u092a\\u0930 THC \\u092a\\u094d\\u0930\\u094b\\u0924\\u094d\\u0938\\u093e\\u0939\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0902, \\u0935\\u093f\\u091c\\u094d\\u091e\\u093e\\u092a\\u0928\\u094b\\u0902 \\u092a\\u0930 \\u092a\\u094d\\u0930\\u0924\\u093f\\u092c\\u0902\\u0927 \\u0932\\u0917\\u093e\\u0924\\u0940 \\u0939\\u0948\\u0902, \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926 \\u092a\\u0930\\u0940\\u0915\\u094d\\u0937\\u0923 \\u0914\\u0930 \\u0932\\u0947\\u092c\\u0932\\u093f\\u0902\\u0917 \\u0915\\u0940 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e \\u0914\\u0930 \\u0909\\u091a\\u094d\\u091a \\u0935\\u093e\\u0939\\u0928\\u091a\\u093e\\u0932\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0926\\u0902\\u0921 \\u0938\\u094d\\u092a\\u0937\\u094d\\u091f \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u0909\\u0926\\u094d\\u092f\\u094b\\u0917\\u093f\\u0915 \\u092d\\u0942\\u091f\\u0942: \\u0915\\u0908 \\u0926\\u0947\\u0936\\u094b\\u0902 \\u0928\\u0947 THC \\u0938\\u0902\\u0918\\u091f\\u0928 \\u0915\\u0947 \\u0909\\u091a\\u094d\\u091a\\u0924\\u092e \\u0935\\u093f\\u0926\\u094d\\u0927\\u093f \\u0938\\u0947 (\\u092e\\u093e\\u0930\\u093f\\u091c\\u0941\\u0906\\u0928\\u093e) \\u0914\\u0930 \\u0925\\u0915\\u094d\\u0915\\u093e THC \\u0938\\u0902\\u0918\\u091f\\u0928 \\u0915\\u0947 \\u0909\\u091a\\u094d\\u091a\\u0924\\u092e \\u0935\\u093f\\u0926\\u094d\\u0927\\u093f \\u0938\\u0947 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0909\\u0926\\u094d\\u092f\\u094b\\u0917\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0938\\u0915\\u093e \\u0905\\u0902\\u0924\\u0930 \\u0915\\u093f\\u092f\\u093e \\u0939\\u0948\\u0964 \\u0914\\u0926\\u094d\\u092f\\u094b\\u0917\\u093f\\u0915 \\u092d\\u0942\\u091f\\u0942 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0928\\u093f\\u092f\\u092e\\u094b\\u0902 \\u0915\\u093e \\u0935\\u093f\\u0927\\u093e\\u0928 \\u0907\\u0938\\u0915\\u0940 \\u0916\\u0947\\u0924\\u0940, \\u092a\\u094d\\u0930\\u0938\\u0902\\u0938\\u094d\\u0915\\u0930\\u0923, \\u0914\\u0930 \\u092b\\u093e\\u0907\\u092c\\u0930, \\u091f\\u0947\\u0915\\u094d\\u0938\\u091f\\u093e\\u0907\\u0932, \\u0914\\u0930 \\u0938\\u0940\\u092c\\u0940\\u0921\\u0940 \\u0909\\u0924\\u094d\\u092a\\u093e\\u0926\\u0928 \\u091c\\u0948\\u0938\\u0947 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0914\\u0926\\u094d\\u092f\\u094b\\u0917\\u093f\\u0915 \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0907\\u0938\\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0948\\u0938\\u0947 \\u0915\\u0930\\u0947\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u0938\\u0902\\u0918 \\u092c\\u0928\\u093e\\u092e \\u0930\\u093e\\u091c\\u094d\\u092f\\/\\u092a\\u094d\\u0930\\u093e\\u0902\\u0924 \\u0915\\u093e\\u0928\\u0942\\u0928: \\u0915\\u0941\\u091b \\u0926\\u0947\\u0936\\u094b\\u0902 \\u092e\\u0947\\u0902, \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0938\\u093e\\u092e\\u093e\\u0928\\u094d\\u092f\\u0924: \\u0915\\u0947\\u0902\\u0926\\u094d\\u0930\\u0940\\u092f \\u0914\\u0930 \\u0938\\u094d\\u0925\\u093e\\u0928\\u0940\\u092f \\u0938\\u0930\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u094d\\u0924\\u0930 \\u092a\\u0930 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928\\u0924\\u093e \\u0926\\u093f\\u0916\\u093e \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u091c\\u092c\\u0915\\u093f \\u0915\\u0947\\u0902\\u0926\\u094d\\u0930\\u0940\\u092f \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0906\\u092e\\u0924\\u094c\\u0930 \\u092a\\u0930 \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0915\\u094b \\u0928\\u093f\\u092f\\u0902\\u0924\\u094d\\u0930\\u093f\\u0924 \\u092a\\u0926\\u093e\\u0930\\u094d\\u0925 \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u0935\\u0930\\u094d\\u0917\\u0940\\u0915\\u0943\\u0924 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948, \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u0917\\u0924 \\u0930\\u093e\\u091c\\u094d\\u092f \\u092f\\u093e \\u092a\\u094d\\u0930\\u093e\\u0902\\u0924 \\u0938\\u094d\\u0924\\u0930\\u094b\\u0902 \\u092a\\u0930 \\u0905\\u092a\\u0928\\u0947 \\u0928\\u093f\\u0930\\u094d\\u0926\\u0947\\u0936\\u0928\\u094b\\u0902 \\u0915\\u094b \\u0932\\u093e\\u0917\\u0942 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u091c\\u093f\\u0938\\u092e\\u0947\\u0902 \\u091a\\u093f\\u0915\\u093f\\u0924\\u094d\\u0938\\u093e \\u092f\\u093e \\u092e\\u0928\\u094b\\u0930\\u0902\\u091c\\u0928\\u093f\\u0915 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0935\\u0948\\u0927\\u0940\\u0915\\u0930\\u0923 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0915\\u093e\\u0928\\u0942\\u0928: \\u0935\\u0948\\u0936\\u094d\\u0935\\u093f\\u0915 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0915\\u0940 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940\\u0924\\u093e \\u090f\\u0915 \\u0926\\u0947\\u0936 \\u0938\\u0947 \\u0926\\u0942\\u0938\\u0930\\u0947 \\u0926\\u0947\\u0936 \\u0924\\u0915 \\u092d\\u093f\\u0928\\u094d\\u0928 \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948, \\u0914\\u0930 \\u090f\\u0915\\u0932 \\u0928\\u0915\\u093e\\u0930\\u093e\\u0924\\u094d\\u092e\\u0915 \\u0926\\u0935\\u093e \\u0915\\u0947 \\u090f\\u0915\\u0932 \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 \\u091c\\u0948\\u0938\\u0947 \\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0938\\u0902\\u0927\\u093f\\u092f\\u093e\\u0902, \\u0926\\u0947\\u0936\\u094b\\u0902 \\u0915\\u094b \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0928\\u093f\\u092f\\u0902\\u0924\\u094d\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0924\\u0930\\u0940\\u0915\\u0947 \\u0915\\u094b \\u0915\\u0948\\u0938\\u0947 \\u0905\\u092a\\u0928\\u093e\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u092a\\u0930 \\u092a\\u094d\\u0930\\u092d\\u093e\\u0935 \\u0921\\u093e\\u0932 \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u0915\\u0941\\u091b \\u0926\\u0947\\u0936 \\u0906\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0914\\u0930 \\u0918\\u0930\\u0947\\u0932\\u0942 \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0915\\u093e\\u0928\\u0942\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u091f\\u0915\\u0930\\u093e\\u0935\\u094b\\u0902 \\u0915\\u093e \\u0938\\u093e\\u092e\\u0928\\u093e \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u0915\\u094d\\u092f\\u094b\\u0902\\u0915\\u093f \\u0935\\u0947 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0926\\u0947\\u0936\\u0940\\u092f \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0915\\u093e\\u0928\\u0942\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0935\\u093f\\u0930\\u094b\\u0927\\u0940 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0915\\u093e \\u0905\\u092a\\u0930\\u093e\\u0927\\u0940\\u0915\\u0930\\u0923: \\u0915\\u0941\\u091b \\u092a\\u0930\\u093f\\u092f\\u094b\\u091c\\u0928\\u093e\\u0913\\u0902 \\u092e\\u0947\\u0902, \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u093e \\u0905\\u092a\\u0930\\u093e\\u0927\\u0940\\u0915\\u0930\\u0923 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0915\\u093e \\u0905\\u0930\\u094d\\u0925 \\u0939\\u0948 \\u0915\\u093f \\u092f\\u0939 \\u091b\\u094b\\u091f\\u0947 \\u092e\\u093e\\u0924\\u094d\\u0930\\u093e \\u092e\\u0947\\u0902 \\u0927\\u0930\\u0928\\u0947 \\u0915\\u094b \\u090f\\u0915 \\u0928\\u093e\\u0917\\u0930\\u093f\\u0915 \\u0905\\u092a\\u0930\\u093e\\u0927 \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u0926\\u0947\\u0916\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948 \\u0914\\u0930 \\u092f\\u0939 \\u090f\\u0915 \\u0915\\u094d\\u0930\\u093f\\u092e\\u093f\\u0928\\u0932 \\u0905\\u092a\\u0930\\u093e\\u0927 \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u0928\\u0939\\u0940\\u0902 \\u0926\\u0947\\u0916\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0905\\u092a\\u0930\\u093e\\u0927\\u0940\\u0915\\u0930\\u0923 \\u0915\\u093e \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f \\u0915\\u094d\\u0930\\u093f\\u092e\\u093f\\u0928\\u0932 \\u0928\\u094d\\u092f\\u093e\\u092f \\u0924\\u0902\\u0924\\u094d\\u0930 \\u092a\\u0930 \\u092c\\u094b\\u091d \\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0938\\u093e\\u0925-\\u0938\\u093e\\u0925 \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0915\\u094b \\u092a\\u0942\\u0930\\u0940 \\u0924\\u0930\\u0939 \\u0935\\u0948\\u0927 \\u0928\\u0939\\u0940\\u0902 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n\\r\\n<p>\\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0914\\u0930 \\u0935\\u094d\\u092f\\u0935\\u0938\\u093e\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0939\\u0948 \\u091c\\u094b \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0909\\u0926\\u094d\\u092f\\u094b\\u0917 \\u092e\\u0947\\u0902 \\u0915\\u093e\\u0930\\u094d\\u092f\\u0930\\u0924 \\u0939\\u0948\\u0902 \\u092f\\u093e \\u0915\\u0948\\u0928\\u0947\\u092c\\u093f\\u0938 \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u093e \\u0935\\u093f\\u091a\\u093e\\u0930 \\u0915\\u0930 \\u0930\\u0939\\u0947 \\u0939\\u0948\\u0902 \\u0924\\u093e\\u0915\\u093f \\u0935\\u0947 \\u0905\\u092a\\u0930\\u093e\\u0927\\u093f\\u0915\\u0924\\u093e \\u0938\\u0947 \\u092c\\u091a \\u0938\\u0915\\u0947\\u0902 \\u0914\\u0930 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u092a\\u0930\\u093f\\u0923\\u093e\\u092e\\u094b\\u0902 \\u0938\\u0947 \\u092c\\u091a \\u0938\\u0915\\u0947\\u0902\\u0964<\\/p>","ar":"<p>\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u064a\\u0634\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0625\\u0637\\u0627\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a \\u0627\\u0644\\u0630\\u064a \\u064a\\u062d\\u0643\\u0645 \\u0632\\u0631\\u0627\\u0639\\u0629 \\u0648\\u062d\\u064a\\u0627\\u0632\\u0629 \\u0648\\u062a\\u0648\\u0632\\u064a\\u0639 \\u0648\\u0628\\u064a\\u0639 \\u0648\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u0642\\u0646\\u0628\\u060c \\u0627\\u0644\\u0645\\u0639\\u0631\\u0648\\u0641 \\u0634\\u0627\\u0626\\u0639\\u064b\\u0627 \\u0628\\u0627\\u0633\\u0645 \\u0627\\u0644\\u0645\\u0627\\u0631\\u064a\\u062c\\u0648\\u0627\\u0646\\u0627 \\u0623\\u0648 \\u0627\\u0644\\u062d\\u0634\\u064a\\u0634. \\u0639\\u0644\\u0649 \\u0645\\u0631 \\u0627\\u0644\\u0633\\u0646\\u064a\\u0646\\u060c \\u062a\\u0637\\u0648\\u0631\\u062a \\u0627\\u0644\\u0645\\u0648\\u0627\\u0642\\u0641 \\u0648\\u0627\\u0644\\u062a\\u0634\\u0631\\u064a\\u0639\\u0627\\u062a \\u0627\\u0644\\u0645\\u062d\\u064a\\u0637\\u0629 \\u0628\\u0627\\u0644\\u0642\\u0646\\u0628 \\u0628\\u0634\\u0643\\u0644 \\u0643\\u0628\\u064a\\u0631\\u060c \\u0645\\u0645\\u0627 \\u0623\\u062f\\u0649 \\u0625\\u0644\\u0649 \\u0645\\u0646\\u0638\\u0631 \\u0642\\u0627\\u0646\\u0648\\u0646\\u064a \\u0645\\u0639\\u0642\\u062f \\u0648\\u062f\\u064a\\u0646\\u0627\\u0645\\u064a\\u0643\\u064a \\u0641\\u064a \\u0645\\u062e\\u062a\\u0644\\u0641 \\u0627\\u0644\\u0633\\u064a\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0641\\u064a \\u062c\\u0645\\u064a\\u0639 \\u0623\\u0646\\u062d\\u0627\\u0621 \\u0627\\u0644\\u0639\\u0627\\u0644\\u0645. \\u064a\\u063a\\u0637\\u064a \\u0639\\u0627\\u062f\\u0629 \\u0645\\u062d\\u062a\\u0648\\u0649 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0627\\u0644\\u062a\\u0627\\u0644\\u064a\\u0629:<\\/p>\\r\\n\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u062a\\u0634\\u0631\\u064a\\u0639\\u0627\\u062a \\u062a\\u0634\\u0631\\u064a\\u0639 \\u0627\\u0644\\u0642\\u0646\\u0628: \\u0627\\u062e\\u062a\\u0627\\u0631\\u062a \\u0628\\u0639\\u0636 \\u0627\\u0644\\u062f\\u0648\\u0644 \\u0648\\u0627\\u0644\\u0648\\u0644\\u0627\\u064a\\u0627\\u062a \\u062a\\u0634\\u0631\\u064a\\u0639 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0644\\u0623\\u063a\\u0631\\u0627\\u0636 \\u0637\\u0628\\u064a\\u0629 \\u0648\\/\\u0623\\u0648 \\u062a\\u0631\\u0641\\u064a\\u0647\\u064a\\u0629. \\u064a\\u062a\\u0636\\u0645\\u0646 \\u0627\\u0644\\u062a\\u0634\\u0631\\u064a\\u0639 \\u063a\\u0627\\u0644\\u0628\\u064b\\u0627 \\u0625\\u0642\\u0627\\u0645\\u0629 \\u0646\\u0638\\u0627\\u0645 \\u062a\\u0646\\u0638\\u064a\\u0645\\u064a \\u0644\\u0644\\u0633\\u064a\\u0637\\u0631\\u0629 \\u0648\\u0627\\u0644\\u0625\\u0634\\u0631\\u0627\\u0641 \\u0639\\u0644\\u0649 \\u0625\\u0646\\u062a\\u0627\\u062c \\u0648\\u062a\\u0648\\u0632\\u064a\\u0639 \\u0648\\u0628\\u064a\\u0639 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a \\u0627\\u0644\\u0642\\u0646\\u0628. \\u062a\\u062d\\u062f\\u062f \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0645\\u0646 \\u064a\\u0645\\u0643\\u0646\\u0647 \\u0627\\u0644\\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0641\\u064a \\u0635\\u0646\\u0627\\u0639\\u0629 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0648\\u0645\\u062a\\u0637\\u0644\\u0628\\u0627\\u062a \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u062a\\u0631\\u062e\\u064a\\u0635 \\u0648\\u0645\\u0639\\u0627\\u064a\\u064a\\u0631 \\u0633\\u0644\\u0627\\u0645\\u0629 \\u0627\\u0644\\u0645\\u0646\\u062a\\u062c.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u0627\\u0644\\u0642\\u0646\\u0628 \\u0627\\u0644\\u0637\\u0628\\u064a: \\u0623\\u062f\\u0631\\u0643\\u062a \\u0627\\u0644\\u0639\\u062f\\u064a\\u062f \\u0645\\u0646 \\u0627\\u0644\\u0633\\u064a\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0625\\u0645\\u0643\\u0627\\u0646\\u0627\\u062a \\u0627\\u0644\\u0639\\u0644\\u0627\\u062c\\u064a\\u0629 \\u0644\\u0644\\u0642\\u0646\\u0628 \\u0648\\u0623\\u0646\\u0634\\u0623\\u062a \\u0625\\u0637\\u0627\\u0631\\u0627\\u062a \\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0627\\u0644\\u0637\\u0628\\u064a. \\u062a\\u062a\\u0637\\u0644\\u0628 \\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0627\\u0644\\u0637\\u0628\\u064a \\u0639\\u0627\\u062f\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0631\\u0636\\u0649 \\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u062a\\u0648\\u0635\\u064a\\u0629 \\u0637\\u0628\\u064a\\u0629 \\u0623\\u0648 \\u0648\\u0635\\u0641\\u0629 \\u0637\\u0628\\u064a\\u0629 \\u0645\\u0646 \\u0645\\u0642\\u062f\\u0645 \\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0631\\u062e\\u0635 \\u0644\\u0647 \\u0644\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0644\\u062d\\u0627\\u0644\\u0627\\u062a \\u0637\\u0628\\u064a\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u062a\\u0631\\u0641\\u064a\\u0647\\u064a: \\u0641\\u064a \\u0627\\u0644\\u0645\\u0646\\u0627\\u0637\\u0642 \\u062d\\u064a\\u062b \\u064a\\u064f\\u0633\\u0645\\u062d \\u0628\\u0627\\u0644\\u0642\\u0646\\u0628 \\u0644\\u0623\\u063a\\u0631\\u0627\\u0636 \\u062a\\u0631\\u0641\\u064a\\u0647\\u064a\\u0629\\u060c \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0627\\u0644\\u0628\\u0627\\u0644\\u063a\\u064a\\u0646 \\u0628\\u0639\\u062f \\u0633\\u0646 \\u0645\\u0639\\u064a\\u0646\\u0629 \\u0634\\u0631\\u0627\\u0621 \\u0648\\u062d\\u064a\\u0627\\u0632\\u0629 \\u0645\\u0646\\u062a\\u062c\\u0627\\u062a \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0644\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a. \\u0642\\u062f \\u064a\\u062a\\u0631\\u062a\\u0628 \\u0639\\u0644\\u0649 \\u062a\\u0634\\u0631\\u064a\\u0639 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u062a\\u0631\\u0641\\u064a\\u0647\\u064a \\u0642\\u064a\\u0648\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0643\\u0645\\u064a\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0627\\u0645\\u062a\\u0644\\u0627\\u0643\\u0647\\u0627\\u060c \\u0648\\u0623\\u0645\\u0627\\u0643\\u0646 \\u0627\\u0633\\u062a\\u0647\\u0644\\u0627\\u0643\\u0647\\u0627\\u060c \\u0648\\u0644\\u0648\\u0627\\u0626\\u062d \\u0644\\u0636\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0633\\u0644\\u0627\\u0645\\u0629 \\u0627\\u0644\\u0639\\u0627\\u0645\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u0627\\u0644\\u062a\\u0631\\u0627\\u062e\\u064a\\u0635 \\u0648\\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645: \\u064a\\u062d\\u0643\\u0645 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u063a\\u0627\\u0644\\u0628\\u064b\\u0627 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0645\\u0646\\u062d \\u0627\\u0644\\u062a\\u0631\\u0627\\u062e\\u064a\\u0635 \\u0644\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0641\\u064a \\u0632\\u0631\\u0627\\u0639\\u0629 \\u0648\\u0645\\u0639\\u0627\\u0644\\u062c\\u0629 \\u0648\\u062a\\u0648\\u0632\\u064a\\u0639 \\u0648\\u0628\\u064a\\u0639 \\u0627\\u0644\\u0642\\u0646\\u0628. \\u062a\\u0634\\u0645\\u0644 \\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u0627\\u062a \\u0642\\u0636\\u0627\\u064a\\u0627 \\u0645\\u062b\\u0644 \\u0645\\u062a\\u0637\\u0644\\u0628\\u0627\\u062a \\u0627\\u0644\\u0623\\u0645\\u0627\\u0646\\u060c \\u0648\\u0645\\u0631\\u0627\\u0642\\u0628\\u0629 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629\\u060c \\u0648\\u0642\\u064a\\u0648\\u062f \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a\\u060c \\u0648\\u0627\\u0644\\u0636\\u0631\\u0627\\u0626\\u0628\\u060c \\u0648\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u062a\\u062e\\u0637\\u064a\\u0637 \\u0644\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0630\\u0627\\u062a \\u0627\\u0644\\u0635\\u0644\\u0629 \\u0628\\u0627\\u0644\\u0642\\u0646\\u0628.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u0627\\u0644\\u0635\\u062d\\u0629 \\u0627\\u0644\\u0639\\u0627\\u0645\\u0629 \\u0648\\u0627\\u0644\\u0633\\u0644\\u0627\\u0645\\u0629: \\u064a\\u062a\\u0646\\u0627\\u0648\\u0644 \\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0627\\u0644\\u0645\\u062e\\u0627\\u0648\\u0641 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u0635\\u062d\\u0629 \\u0627\\u0644\\u0639\\u0627\\u0645\\u0629 \\u0648\\u0627\\u0644\\u0633\\u0644\\u0627\\u0645\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u0642\\u0646\\u0628. \\u0642\\u062f \\u062a\\u062d\\u062f\\u062f \\u062d\\u062f\\u0648\\u062f \\u062a\\u0631\\u0643\\u064a\\u0632 THC\\u060c \\u0648\\u062a\\u0641\\u0631\\u0636 \\u0642\\u064a\\u0648\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0625\\u0639\\u0644\\u0627\\u0646\\u0627\\u062a\\u060c \\u0648\\u062a\\u062a\\u0637\\u0644\\u0628 \\u0627\\u062e\\u062a\\u0628\\u0627\\u0631 \\u0627\\u0644\\u0645\\u0646\\u062a\\u062c \\u0648\\u0648\\u0633\\u0645\\u0647\\u060c \\u0648\\u062a\\u062d\\u062f\\u062f \\u0627\\u0644\\u0639\\u0642\\u0648\\u0628\\u0627\\u062a \\u0644\\u0644\\u0642\\u064a\\u0627\\u062f\\u0629 \\u062a\\u062d\\u062a \\u062a\\u0623\\u062b\\u064a\\u0631 \\u0627\\u0644\\u0642\\u0646\\u0628.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u0627\\u0644\\u0642\\u0646\\u0628 \\u0627\\u0644\\u0635\\u0646\\u0627\\u0639\\u064a: \\u0627\\u0645\\u062a\\u064a\\u0627\\u0632 \\u0627\\u0644\\u0639\\u062f\\u064a\\u062f \\u0645\\u0646 \\u0627\\u0644\\u062f\\u0648\\u0644 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0630\\u0648 \\u0627\\u0644\\u062a\\u0631\\u0643\\u064a\\u0632 \\u0627\\u0644\\u0639\\u0627\\u0644\\u064a \\u0645\\u0646 THC (\\u0627\\u0644\\u0645\\u0627\\u0631\\u064a\\u062c\\u0648\\u0627\\u0646\\u0627) \\u0648\\u0627\\u0644\\u0642\\u0646\\u0628 \\u0630\\u0648 \\u0627\\u0644\\u062a\\u0631\\u0643\\u064a\\u0632 \\u0627\\u0644\\u0645\\u0646\\u062e\\u0641\\u0636 \\u0645\\u0646 THC (\\u0627\\u0644\\u0642\\u0646\\u0628 \\u0627\\u0644\\u0635\\u0646\\u0627\\u0639\\u064a). \\u062a\\u062d\\u0643\\u0645 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u0642\\u0646\\u0628 \\u0627\\u0644\\u0635\\u0646\\u0627\\u0639\\u064a \\u0632\\u0631\\u0627\\u0639\\u062a\\u0647 \\u0648\\u0645\\u0639\\u0627\\u0644\\u062c\\u062a\\u0647 \\u0648\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645\\u0647 \\u0644\\u0623\\u063a\\u0631\\u0627\\u0636 \\u0635\\u0646\\u0627\\u0639\\u064a\\u0629 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629\\u060c \\u0645\\u062b\\u0644 \\u0627\\u0644\\u0623\\u0644\\u064a\\u0627\\u0641 \\u0648\\u0627\\u0644\\u0646\\u0633\\u064a\\u062c \\u0648\\u0625\\u0646\\u062a\\u0627\\u062c CBD.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u0641\\u062f\\u0631\\u0627\\u0644\\u064a\\u0629 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u0648\\u0644\\u0627\\u0626\\u064a\\u0629\\/\\u0627\\u0644\\u0625\\u0642\\u0644\\u064a\\u0645\\u064a\\u0629: \\u0641\\u064a \\u0628\\u0639\\u0636 \\u0627\\u0644\\u062f\\u0648\\u0644\\u060c \\u0642\\u062f \\u062a\\u062e\\u062a\\u0644\\u0641 \\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0628\\u0634\\u0643\\u0644 \\u0643\\u0628\\u064a\\u0631 \\u0628\\u064a\\u0646 \\u0645\\u0633\\u062a\\u0648\\u064a\\u0627\\u062a \\u0627\\u0644\\u062d\\u0643\\u0648\\u0645\\u0629 \\u0627\\u0644\\u0641\\u062f\\u0631\\u0627\\u0644\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0625\\u0642\\u0644\\u064a\\u0645\\u064a\\u0629. \\u0641\\u064a \\u062d\\u064a\\u0646 \\u0642\\u062f \\u064a\\u0635\\u0646\\u0641 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0641\\u062f\\u0631\\u0627\\u0644\\u064a \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0643\\u0645\\u0627\\u062f\\u0629 \\u0645\\u062d\\u0638\\u0648\\u0631\\u0629\\u060c \\u0642\\u062f \\u062a\\u062e\\u062a\\u0627\\u0631 \\u0627\\u0644\\u0648\\u0644\\u0627\\u064a\\u0627\\u062a \\u0627\\u0644\\u0641\\u0631\\u062f\\u064a\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u0645\\u0642\\u0627\\u0637\\u0639\\u0627\\u062a \\u062a\\u0646\\u0641\\u064a\\u0630 \\u062a\\u0634\\u0631\\u064a\\u0639\\u0627\\u062a\\u0647\\u0627 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u062a\\u0634\\u0631\\u064a\\u0639\\u0627\\u062a \\u062a\\u0634\\u0631\\u064a\\u0639 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0644\\u0623\\u063a\\u0631\\u0627\\u0636 \\u0637\\u0628\\u064a\\u0629 \\u0623\\u0648 \\u062a\\u0631\\u0641\\u064a\\u0647\\u064a\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0627\\u0644\\u062f\\u0648\\u0644\\u064a\\u0629: \\u064a\\u062e\\u062a\\u0644\\u0641 \\u062a\\u0634\\u0631\\u064a\\u0639 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0639\\u0644\\u0649 \\u0645\\u0633\\u062a\\u0648\\u0649 \\u0627\\u0644\\u0639\\u0627\\u0644\\u0645 \\u0645\\u0646 \\u062f\\u0648\\u0644\\u0629 \\u0644\\u0623\\u062e\\u0631\\u0649\\u060c \\u0648\\u0627\\u0644\\u0645\\u0639\\u0627\\u0647\\u062f\\u0627\\u062a \\u0627\\u0644\\u062f\\u0648\\u0644\\u064a\\u0629\\u060c \\u0645\\u062b\\u0644 \\u0627\\u062a\\u0641\\u0627\\u0642\\u064a\\u0629 \\u0627\\u0644\\u0623\\u0645\\u0645 \\u0627\\u0644\\u0645\\u062a\\u062d\\u062f\\u0629 \\u0627\\u0644\\u0641\\u0631\\u062f\\u064a\\u0629 \\u0628\\u0634\\u0623\\u0646 \\u0627\\u0644\\u0645\\u062e\\u062f\\u0631\\u0627\\u062a \\u0627\\u0644\\u0642\\u0648\\u064a\\u0629\\u060c \\u062a\\u0624\\u062b\\u0631 \\u0641\\u064a \\u0643\\u064a\\u0641\\u064a\\u0629 \\u062a\\u0646\\u0627\\u0648\\u0644 \\u0627\\u0644\\u0628\\u0644\\u062f\\u0627\\u0646 \\u0644\\u0645\\u0631\\u0627\\u0642\\u0628\\u0629 \\u0627\\u0644\\u0642\\u0646\\u0628. \\u0642\\u062f \\u062a\\u0648\\u0627\\u062c\\u0647 \\u0628\\u0639\\u0636 \\u0627\\u0644\\u062f\\u0648\\u0644 \\u062a\\u062d\\u062f\\u064a\\u0627\\u062a \\u0628\\u0633\\u0628\\u0628 \\u0627\\u0644\\u062a\\u0636\\u0627\\u0631\\u0628 \\u0628\\u064a\\u0646 \\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0627\\u0644\\u062f\\u0648\\u0644\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0645\\u062d\\u0644\\u064a\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u062a\\u062c\\u0631\\u064a\\u0645 \\u0627\\u0644\\u0642\\u0646\\u0628: \\u0641\\u064a \\u0628\\u0639\\u0636 \\u0627\\u0644\\u0633\\u064a\\u0627\\u0642\\u0627\\u062a\\u060c \\u0642\\u062f \\u064a\\u062a\\u0645 \\u062a\\u062c\\u0631\\u064a\\u0645 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u0642\\u0646\\u0628\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0639\\u0646\\u064a \\u0623\\u0646 \\u062d\\u064a\\u0627\\u0632\\u0629 \\u0643\\u0645\\u064a\\u0627\\u062a \\u0635\\u063a\\u064a\\u0631\\u0629 \\u064a\\u062a\\u0645 \\u0627\\u0644\\u062a\\u0639\\u0627\\u0645\\u0644 \\u0645\\u0639\\u0647\\u0627 \\u0643\\u0645\\u062e\\u0627\\u0644\\u0641\\u0629 \\u0645\\u062f\\u0646\\u064a\\u0629 \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u062c\\u0631\\u064a\\u0645\\u0629 \\u062c\\u0646\\u0627\\u0626\\u064a\\u0629. \\u064a\\u0647\\u062f\\u0641 \\u0627\\u0644\\u062a\\u062c\\u0631\\u064a\\u0645 \\u0625\\u0644\\u0649 \\u062a\\u062e\\u0641\\u064a\\u0641 \\u0627\\u0644\\u0639\\u0628\\u0621 \\u0639\\u0644\\u0649 \\u0646\\u0638\\u0627\\u0645 \\u0627\\u0644\\u0639\\u062f\\u0627\\u0644\\u0629 \\u0627\\u0644\\u062c\\u0646\\u0627\\u0626\\u064a\\u0629 \\u062f\\u0648\\u0646 \\u062a\\u0634\\u0631\\u064a\\u0639 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0628\\u0627\\u0644\\u0643\\u0627\\u0645\\u0644.<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n\\r\\n<p>\\u064a\\u062a\\u0637\\u0648\\u0631 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0628\\u0627\\u0633\\u062a\\u0645\\u0631\\u0627\\u0631 \\u0645\\u0639 \\u062a\\u063a\\u064a\\u0631 \\u0627\\u0644\\u0645\\u0648\\u0627\\u0642\\u0641 \\u062a\\u062c\\u0627\\u0647 \\u0627\\u0644\\u0642\\u0646\\u0628\\u060c \\u0648\\u062a\\u0642\\u062f\\u0645 \\u0627\\u0644\\u0623\\u0628\\u062d\\u0627\\u062b \\u0627\\u0644\\u0639\\u0644\\u0645\\u064a\\u0629\\u060c \\u0648\\u0627\\u0644\\u0645\\u062c\\u062a\\u0645\\u0639\\u0627\\u062a \\u062a\\u0643\\u0627\\u0641\\u062d \\u0645\\u0639 \\u0642\\u0636\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0635\\u062d\\u0629 \\u0627\\u0644\\u0639\\u0627\\u0645\\u0629 \\u0648\\u0627\\u0644\\u0639\\u062f\\u0627\\u0644\\u0629 \\u0627\\u0644\\u062c\\u0646\\u0627\\u0626\\u064a\\u0629\\u060c \\u0648\\u0627\\u0644\\u0627\\u0639\\u062a\\u0628\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u0627\\u0642\\u062a\\u0635\\u0627\\u062f\\u064a\\u0629. \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0647\\u0645 \\u0623\\u0646 \\u064a\\u0628\\u0642\\u0649 \\u0627\\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0648\\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0627\\u0644\\u0639\\u0627\\u0645\\u0644\\u0629 \\u0641\\u064a \\u0635\\u0646\\u0627\\u0639\\u0629 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0623\\u0648 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0641\\u064a \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u0642\\u0646\\u0628 \\u0639\\u0644\\u0649 \\u062f\\u0631\\u0627\\u064a\\u0629 \\u0628\\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0648\\u0627\\u0644\\u062a\\u0634\\u0631\\u064a\\u0639\\u0627\\u062a \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0645\\u0646\\u0637\\u0642\\u062a\\u0647\\u0645 \\u0644\\u0636\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0648\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0639\\u0648\\u0627\\u0642\\u0628 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629.<\\/p>"}',
                'icon' => '/images/therapist_main_categories/64cb84505ae6b.png',
                'id' => 2,
                'image' => '/images/therapist_main_categories/64cb84505a651.png',
                'is_active' => 1,
                'is_featured' => 1,
                'name' => '{"en":"Cannabis \\u00a0Therapy","hi":"\\u0915\\u0948\\u0928\\u092c\\u093f\\u0938 \\u0915\\u093e\\u0928\\u0942\\u0928","ar":"\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0642\\u0646\\u0628"}',
                'slug' => 'cannabis-therapy-2',
                'updated_at' => '2023-10-10 18:50:52',
            ),
            2 => 
            array (
                'created_at' => '2023-08-03 12:45:04',
                'deleted_at' => NULL,
            'description' => '{"en":"<p>Commercial transactions refer to the exchange of goods, services, or money between businesses or entities in the context of conducting business. These transactions are fundamental to the functioning of the economy and are governed by various therapys and principles. Here are some key aspects of commercial transactions:<\\/p>\\r\\n\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p>Types of Commercial Transactions: Commercial transactions can take various forms, including the sale of goods, the provision of services, leasing or renting of assets, licensing of intellectual property, joint ventures, mergers and acquisitions, financing agreements, and more.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Contractual Agreements: Most commercial transactions are formalized through contractual agreements. Contracts outline the terms and conditions of the transaction, including the rights and obligations of the parties involved, pricing, payment terms, delivery schedules, warranties, and remedies in case of breach.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Offer and Acceptance: A commercial transaction typically starts with one party making an offer and the other party accepting it. Once there is a meeting of minds (offer and acceptance), a legally binding agreement is formed.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Consideration: Consideration is a crucial element in a commercial contract. It refers to the value or benefit that each party promises to give or receive in exchange for their obligations. Consideration can be money, goods, services, or a promise to do or refrain from doing something.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Performance and Delivery: After the contract is formed, each party is obligated to perform their part of the deal. This could involve delivering goods, providing services, making payments, or fulfilling other obligations as specified in the contract.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Risk and Title: In the context of the sale of goods, the concept of risk and title transfer is essential. It determines when the ownership and risk of loss or damage to the goods pass from the seller to the buyer.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Payment and Financing: Payment terms in commercial transactions can vary, including immediate payment, installment payments, or credit arrangements. Financing agreements may be involved to facilitate the transaction, especially in large-scale commercial deals.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Remedies for Breach: If one party fails to fulfill their obligations under the contract (breach), the non-breaching party may have various remedies, such as seeking damages, specific performance (forcing the other party to perform as promised), or termination of the contract.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Regulatory Compliance: Commercial transactions may be subject to specific therapys and regulations, depending on the nature of the transaction, the industry involved, and the jurisdictions in which the parties operate. Compliance with these therapys is essential to avoid legal issues and penalties.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Confidentiality and Non-Disclosure: In some commercial transactions, parties may need to exchange sensitive information. Non-disclosure agreements (NDAs) may be used to protect confidential information from being shared with third parties.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>International Commercial Transactions: Cross-border commercial transactions involve additional complexities due to different legal systems, cultural differences, language barriers, and international trade regulations.<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n\\r\\n<p>Commercial transactions are critical for businesses to grow, expand their operations, and foster economic development. Ensuring that these transactions are conducted with clarity, transparency, and adherence to relevant therapys is essential for the success and sustainability of businesses in the marketplace. Legal counsel and due diligence play a vital role in facilitating smooth commercial transactions and mitigating potential risks.<\\/p>\\r\\n\\r\\n<p>&nbsp;<\\/p>\\r\\n\\r\\n<p>&nbsp;<\\/p>","hi":"<p>\\u0935\\u093e\\u0923\\u093f\\u091c\\u094d\\u092f\\u093f\\u0915 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0909\\u0926\\u094d\\u092f\\u092e\\u093f\\u092f\\u094b\\u0902 \\u092f\\u093e \\u0938\\u0902\\u0938\\u094d\\u0925\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0935\\u0938\\u094d\\u0924\\u0941\\u0913\\u0902, \\u0938\\u0947\\u0935\\u093e\\u0913\\u0902 \\u092f\\u093e \\u0927\\u0928 \\u0915\\u0940 \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u092a\\u0930 \\u0938\\u0902\\u0926\\u0930\\u094d\\u092d\\u093f\\u0924 \\u0939\\u0948\\u0902 \\u091c\\u094b \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930 \\u0915\\u0947 \\u092a\\u0930\\u093f\\u092a\\u094d\\u0930\\u0947\\u0915\\u094d\\u0937\\u094d\\u092f \\u092e\\u0947\\u0902 \\u0939\\u094b\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0947 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0905\\u0930\\u094d\\u0925\\u0935\\u094d\\u092f\\u0935\\u0938\\u094d\\u0925\\u093e \\u0915\\u0947 \\u0938\\u0902\\u091a\\u093e\\u0932\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092e\\u094c\\u0932\\u093f\\u0915 \\u0939\\u0948\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0915\\u093e\\u0928\\u0942\\u0928\\u094b\\u0902 \\u0914\\u0930 \\u0938\\u093f\\u0926\\u094d\\u0927\\u093e\\u0902\\u0924\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0928\\u093f\\u092f\\u0902\\u0924\\u094d\\u0930\\u093f\\u0924 \\u0939\\u094b\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0939\\u093e\\u0901 \\u0935\\u093e\\u0923\\u093f\\u091c\\u094d\\u092f\\u093f\\u0915 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u0915\\u0941\\u091b \\u092a\\u094d\\u0930\\u092e\\u0941\\u0916 \\u092a\\u0939\\u0932\\u0941\\u0913\\u0902 \\u0915\\u093e \\u0909\\u0932\\u094d\\u0932\\u0947\\u0916 \\u0939\\u0948:<\\/p>\\r\\n\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p>\\u0935\\u093e\\u0923\\u093f\\u091c\\u094d\\u092f\\u093f\\u0915 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0915\\u0947 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930: \\u0935\\u093e\\u0923\\u093f\\u091c\\u094d\\u092f\\u093f\\u0915 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0930\\u0942\\u092a\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u091c\\u0948\\u0938\\u0947 \\u092e\\u093e\\u0932 \\u0915\\u0940 \\u092c\\u093f\\u0915\\u094d\\u0930\\u0940, \\u0938\\u0947\\u0935\\u093e\\u0913\\u0902 \\u0915\\u0940 \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928, \\u0938\\u0902\\u092a\\u0924\\u094d\\u0924\\u093f \\u0915\\u0940 \\u0932\\u0940\\u091c\\u093c, \\u092e\\u093e\\u0928\\u0935 \\u0938\\u0902\\u0938\\u093e\\u0927\\u0928 \\u0915\\u0940 \\u0932\\u093e\\u0907\\u0938\\u0947\\u0902\\u0938, \\u0938\\u0902\\u092f\\u0941\\u0915\\u094d\\u0924 \\u0909\\u0926\\u094d\\u092f\\u092e, \\u0935\\u093f\\u0932\\u092f\\u0928 \\u0914\\u0930 \\u0905\\u0927\\u093f\\u0917\\u094d\\u0930\\u0939\\u0923, \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947, \\u0914\\u0930 \\u092d\\u0940\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0905\\u0928\\u0941\\u092c\\u0902\\u0927\\u093f\\u0915 \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947: \\u0905\\u0927\\u093f\\u0915\\u093e\\u0902\\u0936 \\u0935\\u093e\\u0923\\u093f\\u091c\\u094d\\u092f\\u093f\\u0915 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0915\\u094b \\u0938\\u092e\\u091d\\u094c\\u0924\\u0940 \\u0905\\u0928\\u0941\\u092c\\u0902\\u0927\\u094b\\u0902 \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u0906\\u0915\\u0938\\u094d\\u092e\\u093f\\u0915 \\u092c\\u0928\\u093e\\u092f\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0905\\u0928\\u0941\\u092c\\u0902\\u0927 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u0936\\u0930\\u094d\\u0924\\u0947\\u0902 \\u0914\\u0930 \\u0936\\u0930\\u094d\\u0924\\u094b\\u0902 \\u0915\\u093e \\u092c\\u092f\\u093e\\u0928 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u091c\\u093f\\u0938\\u092e\\u0947\\u0902 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u092a\\u0915\\u094d\\u0937\\u094b\\u0902 \\u0915\\u093e \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930 \\u0914\\u0930 \\u0915\\u0930\\u094d\\u0924\\u0935\\u094d\\u092f, \\u092e\\u0942\\u0932\\u094d\\u092f \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u0923, \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0936\\u0930\\u094d\\u0924\\u0947\\u0902, \\u0935\\u093f\\u0924\\u0930\\u0923 \\u0915\\u0940 \\u0905\\u0928\\u0941\\u0938\\u0942\\u091a\\u093f\\u092f\\u093e\\u0901, \\u0935\\u093e\\u0930\\u0902\\u091f\\u0940\\u091c\\u093c, \\u0914\\u0930 \\u0909\\u0932\\u094d\\u0932\\u0902\\u0918\\u0928 \\u0915\\u0940 \\u0938\\u094d\\u0925\\u093f\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0909\\u092a\\u093e\\u092f \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u094b\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u092a\\u094d\\u0930\\u0938\\u094d\\u0924\\u093e\\u0935 \\u0914\\u0930 \\u0938\\u094d\\u0935\\u0940\\u0915\\u0943\\u0924\\u093f: \\u0935\\u093e\\u0923\\u093f\\u091c\\u094d\\u092f\\u093f\\u0915 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0906\\u092e\\u0924\\u094c\\u0930 \\u092a\\u0930 \\u090f\\u0915 \\u092a\\u0915\\u094d\\u0937 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u092a\\u094d\\u0930\\u0938\\u094d\\u0924\\u093e\\u0935 \\u0926\\u0947\\u0928\\u0947 \\u0914\\u0930 \\u0926\\u0942\\u0938\\u0930\\u0947 \\u092a\\u0915\\u094d\\u0937 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0907\\u0938\\u0947 \\u0938\\u094d\\u0935\\u0940\\u0915\\u093e\\u0930 \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u0936\\u0941\\u0930\\u0942 \\u0939\\u094b\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u090f\\u0915\\u092e\\u0924\\u093f \\u0939\\u094b\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0926 (\\u092a\\u094d\\u0930\\u0938\\u094d\\u0924\\u093e\\u0935 \\u0914\\u0930 \\u0938\\u094d\\u0935\\u0940\\u0915\\u0943\\u0924\\u093f), \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092c\\u093e\\u0927\\u094d\\u092f \\u090f\\u0915 \\u0938\\u092e\\u091d\\u094c\\u0924\\u093e \\u092c\\u0928\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0935\\u093f\\u091a\\u093e\\u0930: \\u0935\\u093e\\u0923\\u093f\\u091c\\u094d\\u092f\\u093f\\u0915 \\u0905\\u0928\\u0941\\u092c\\u0902\\u0927 \\u092e\\u0947\\u0902 \\u0935\\u093f\\u091a\\u093e\\u0930 \\u090f\\u0915 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0918\\u091f\\u0915 \\u0939\\u0948\\u0964 \\u092f\\u0939 \\u0909\\u0928\\u0915\\u0940 \\u0935\\u091c\\u0939 \\u092f\\u093e \\u0932\\u093e\\u092d \\u0915\\u094b \\u0938\\u0902\\u0926\\u0930\\u094d\\u092d\\u093f\\u0924 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u091c\\u094b \\u092a\\u094d\\u0930\\u0924\\u094d\\u092f\\u0915\\u094d\\u0937 \\u0915\\u0930\\u094d\\u0924\\u093e \\u0935\\u093e \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924\\u0915\\u0930\\u094d\\u0924\\u093e \\u0905\\u092a\\u0928\\u0947 \\u0935\\u091a\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0935\\u093f\\u0928\\u093f\\u092e\\u092f \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0935\\u093e\\u0926\\u093e \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0935\\u093f\\u091a\\u093e\\u0930 \\u092e\\u0947\\u0902 \\u092a\\u0948\\u0938\\u0947, \\u092e\\u093e\\u0932, \\u0938\\u0947\\u0935\\u093e\\u090f\\u0901, \\u092f\\u093e \\u0915\\u0941\\u091b \\u0915\\u0930\\u0928\\u0947 \\u092f\\u093e \\u0915\\u0941\\u091b \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u0935\\u0902\\u091a\\u093f\\u0924 \\u0930\\u0939\\u0928\\u0947 \\u0915\\u093e \\u0935\\u093e\\u0926\\u093e \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u092a\\u094d\\u0930\\u0926\\u0930\\u094d\\u0936\\u0928 \\u0914\\u0930 \\u0935\\u093f\\u0924\\u0930\\u0923: \\u0905\\u0928\\u0941\\u092c\\u0902\\u0927 \\u092c\\u0928 \\u091c\\u093e\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0926, \\u092a\\u094d\\u0930\\u0924\\u094d\\u092f\\u0947\\u0915 \\u092a\\u0915\\u094d\\u0937 \\u0915\\u094b \\u0938\\u094c\\u0926\\u0947 \\u0915\\u0947 \\u0905\\u092a\\u0928\\u0947 \\u0939\\u093f\\u0938\\u094d\\u0938\\u0947 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092a\\u0930\\u093f\\u092a\\u094d\\u0930\\u0947\\u0915\\u094d\\u0937\\u094d\\u092f \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0907\\u0938\\u092e\\u0947\\u0902 \\u092e\\u093e\\u0932 \\u092a\\u0939\\u0941\\u0902\\u091a\\u093e\\u0928\\u093e, \\u0938\\u0947\\u0935\\u093e\\u090f\\u0901 \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0928\\u093e, \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0915\\u0930\\u0928\\u093e, \\u092f\\u093e \\u0905\\u0928\\u0941\\u092c\\u0902\\u0927 \\u092e\\u0947\\u0902 \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u093f\\u0924 \\u0915\\u0940 \\u0917\\u0908 \\u0905\\u0928\\u094d\\u092f \\u0915\\u0930\\u094d\\u0924\\u0935\\u094d\\u092f\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u091c\\u094b\\u0916\\u093f\\u092e \\u0914\\u0930 \\u0936\\u0940\\u0930\\u094d\\u0937\\u0915: \\u092e\\u093e\\u0932 \\u0915\\u0940 \\u092c\\u093f\\u0915\\u094d\\u0930\\u0940 \\u0915\\u0947 \\u0938\\u0902\\u0926\\u0930\\u094d\\u092d \\u092e\\u0947\\u0902, \\u091c\\u094b\\u0916\\u093f\\u092e \\u0914\\u0930 \\u0936\\u0940\\u0930\\u094d\\u0937\\u0915 \\u0915\\u0947 \\u0927\\u093e\\u0930\\u0923 \\u0915\\u093e \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0905\\u0938\\u0930 \\u0939\\u0948\\u0964 \\u092f\\u0939 \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 \\u0915\\u093f \\u092e\\u093e\\u0932 \\u0915\\u0947 \\u0938\\u094d\\u0935\\u093e\\u092e\\u093f\\u0924\\u094d\\u0935 \\u0914\\u0930 \\u091c\\u094b\\u0916\\u093f\\u092e \\u092f\\u093e \\u0939\\u093e\\u0928\\u093f \\u0915\\u093e \\u091c\\u094b\\u0916\\u093f\\u092e \\u092f\\u093e \\u0939\\u093e\\u0928\\u093f \\u092c\\u093f\\u0915\\u094d\\u0930\\u0940\\u0915\\u0930\\u094d\\u0924\\u093e \\u0938\\u0947 \\u0916\\u0930\\u0940\\u0926\\u093e\\u0930 \\u0915\\u0947 \\u092a\\u093e\\u0938 \\u091c\\u093e\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0914\\u0930 \\u0935\\u093f\\u0924\\u094d\\u0924\\u092a\\u094b\\u0937\\u0923: \\u0935\\u093e\\u0923\\u093f\\u091c\\u094d\\u092f\\u093f\\u0915 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u092e\\u0947\\u0902 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928 \\u0905\\u0928\\u0941\\u0938\\u0942\\u091a\\u093f\\u092f\\u093e\\u0901 \\u092d\\u093f\\u0928\\u094d\\u0928 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0902, \\u0938\\u0939\\u093f\\u0924 \\u0924\\u0941\\u0930\\u0902\\u0924 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928, \\u0906\\u0902\\u0936\\u093f\\u0915 \\u092d\\u0941\\u0917\\u0924\\u093e\\u0928, \\u092f\\u093e \\u090b\\u0923 \\u0935\\u094d\\u092f\\u0935\\u0938\\u094d\\u0925\\u093e\\u090f\\u0901 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0902\\u0964 \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092c\\u0921\\u093c\\u0947 \\u092e\\u093e\\u092a\\u0926\\u0902\\u0921 \\u0935\\u093e\\u0923\\u093f\\u091c\\u094d\\u092f\\u093f\\u0915 \\u0938\\u094c\\u0926\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0915\\u094b \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e\\u091c\\u0928\\u0915 \\u092c\\u0928\\u093e\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0909\\u0932\\u094d\\u0932\\u0902\\u0918\\u0928 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0909\\u092a\\u093e\\u092f: \\u092f\\u0926\\u093f \\u0915\\u094b\\u0908 \\u092a\\u0915\\u094d\\u0937 \\u0905\\u0928\\u0941\\u092c\\u0902\\u0927 \\u0915\\u0947 \\u0924\\u0939\\u0924 \\u0905\\u092a\\u0928\\u0947 \\u0915\\u0930\\u094d\\u0924\\u0935\\u094d\\u092f\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0928\\u0939\\u0940\\u0902 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948 (\\u0909\\u0932\\u094d\\u0932\\u0902\\u0918\\u0928), \\u0924\\u094b \\u0905\\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0940 \\u092a\\u0915\\u094d\\u0937 \\u0915\\u0947 \\u092a\\u093e\\u0938 \\u0928\\u0941\\u0915\\u0938\\u093e\\u0928 \\u0926\\u0930\\u094d\\u091c \\u0915\\u0930\\u0928\\u0947, \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0905\\u0927\\u093f\\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 (\\u0905\\u0928\\u094d\\u092f \\u092a\\u0915\\u094d\\u0937 \\u0915\\u094b \\u0935\\u093e\\u0926\\u093e \\u0915\\u093f\\u090f \\u0917\\u090f \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u0915\\u093e\\u0930\\u094d\\u0930\\u0935\\u093e\\u0908 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f) \\u092f\\u093e \\u0905\\u0928\\u0941\\u092c\\u0902\\u0927 \\u0938\\u092e\\u093e\\u092a\\u0928 \\u091c\\u0948\\u0938\\u0947 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0909\\u092a\\u093e\\u092f \\u0939\\u094b \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0928\\u093f\\u092f\\u093e\\u092e\\u0915\\u0940 \\u0905\\u0928\\u0941\\u092a\\u093e\\u0932\\u0928: \\u0935\\u093e\\u0923\\u093f\\u091c\\u094d\\u092f\\u093f\\u0915 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0935\\u093f\\u0936\\u093f\\u0937\\u094d\\u091f \\u0915\\u093e\\u0928\\u0942\\u0928\\u094b\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u092a\\u0941\\u0930\\u093e\\u0928\\u0947 \\u0915\\u0947 \\u0924\\u0939\\u0924 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0935\\u093e\\u0923\\u093f\\u091c\\u094d\\u092f\\u093f\\u0915 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0915\\u0940 \\u092a\\u094d\\u0930\\u0915\\u0943\\u0924\\u093f, \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0909\\u0926\\u094d\\u092f\\u094b\\u0917, \\u0914\\u0930 \\u0924\\u092c \\u0924\\u0915 \\u0915\\u0947 \\u0935\\u093f\\u0927\\u093f\\u092a\\u094d\\u0930\\u092e\\u093e\\u0923\\u094b\\u0902 \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0928\\u093f\\u0930\\u094d\\u092d\\u0930 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902 \\u0915\\u093f \\u092a\\u0915\\u094d\\u0937 \\u0938\\u0902\\u091a\\u093e\\u0932\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u0907\\u0928 \\u0915\\u093e\\u0928\\u0942\\u0928\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0928\\u093e \\u0935\\u093f\\u0927\\u093f\\u0915 \\u092e\\u0941\\u0926\\u094d\\u0926\\u094b\\u0902 \\u0914\\u0930 \\u0926\\u0902\\u0921\\u094b\\u0902 \\u0938\\u0947 \\u092c\\u091a\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u0924\\u094d\\u092f\\u093e\\u0935\\u0936\\u094d\\u092f\\u0915 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0914\\u0930 \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0915\\u0947 \\u0905\\u0938\\u094d\\u0925\\u093e\\u092f\\u093f\\u0924: \\u0915\\u0941\\u091b \\u0935\\u093e\\u0923\\u093f\\u091c\\u094d\\u092f\\u093f\\u0915 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u092e\\u0947\\u0902 \\u092a\\u0915\\u094d\\u0937\\u094b\\u0902 \\u0915\\u094b \\u0938\\u0902\\u0935\\u0947\\u0926\\u0928\\u0936\\u0940\\u0932 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0915\\u093e \\u0906\\u0926\\u093e\\u0928-\\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0940 \\u091c\\u0930\\u0942\\u0930\\u0924 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0964 \\u0924\\u0940\\u0938\\u0930\\u0947 \\u092a\\u0915\\u094d\\u0937\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0938\\u093e\\u091d\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0930\\u0916\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 (\\u090f\\u0928\\u0921\\u0940\\u090f) \\u0915\\u093e \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0935\\u093e\\u0923\\u093f\\u091c\\u094d\\u092f\\u093f\\u0915 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928: \\u0938\\u0940\\u092e\\u093e\\u0928\\u0941\\u092a\\u093e\\u0924\\u0940 \\u0935\\u093e\\u0923\\u093f\\u091c\\u094d\\u092f\\u093f\\u0915 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0924\\u0902\\u0924\\u094d\\u0930\\u094b\\u0902, \\u0938\\u093e\\u0902\\u0938\\u094d\\u0915\\u0943\\u0924\\u093f\\u0915 \\u092d\\u093f\\u0928\\u094d\\u0928\\u0924\\u093e\\u0913\\u0902, \\u092d\\u093e\\u0937\\u093e \\u0915\\u0940 \\u092c\\u093e\\u0927\\u093e\\u0913\\u0902 \\u0914\\u0930 \\u0905\\u0902\\u0924\\u0930\\u0930\\u093e\\u0937\\u094d\\u091f\\u094d\\u0930\\u0940\\u092f \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930 \\u0935\\u093f\\u0928\\u093f\\u092f\\u092e\\u0928 \\u0915\\u0947 \\u0915\\u093e\\u0930\\u0923 \\u0914\\u0930 \\u0905\\u0927\\u093f\\u0915 \\u091c\\u091f\\u093f\\u0932\\u0924\\u093e\\u0913\\u0902 \\u0915\\u094b \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n\\r\\n<p>\\u0935\\u093e\\u0923\\u093f\\u091c\\u094d\\u092f\\u093f\\u0915 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0909\\u0928\\u0915\\u0947 \\u0935\\u093f\\u0915\\u093e\\u0938, \\u0935\\u093f\\u0938\\u094d\\u0924\\u093e\\u0930 \\u0914\\u0930 \\u0906\\u0930\\u094d\\u0925\\u093f\\u0915 \\u0935\\u093f\\u0915\\u093e\\u0938 \\u0915\\u094b \\u092c\\u0922\\u093c\\u093e\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915 \\u0939\\u0948\\u0902\\u0964 \\u0907\\u0928 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0915\\u094b \\u0938\\u094d\\u092a\\u0937\\u094d\\u091f\\u0924\\u093e, \\u092a\\u093e\\u0930\\u0926\\u0930\\u094d\\u0936\\u093f\\u0924\\u093e \\u0914\\u0930 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u093e\\u0928\\u0942\\u0928\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0915\\u0947 \\u0935\\u094d\\u092f\\u093e\\u092a\\u093e\\u0930\\u094b\\u0902 \\u0915\\u0940 \\u0935\\u093f\\u0926\\u094d\\u092f\\u092e\\u093e\\u0928\\u0924\\u093e \\u0914\\u0930 \\u091f\\u093f\\u0915\\u093e\\u090a\\u0924\\u093e \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915 \\u0939\\u0948\\u0964 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0938\\u0932\\u093e\\u0939 \\u0914\\u0930 \\u092f\\u0925\\u093e\\u0938\\u092e\\u094d\\u092d\\u093e\\u0935\\u0928\\u093e \\u0909\\u0926\\u094d\\u092f\\u092e\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e\\u091c\\u0928\\u0915 \\u0935\\u093e\\u0923\\u093f\\u091c\\u094d\\u092f\\u093f\\u0915 \\u0932\\u0947\\u0928-\\u0926\\u0947\\u0928 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0914\\u0930 \\u0938\\u0902\\u092d\\u093e\\u0935\\u093f\\u0924 \\u091c\\u094b\\u0916\\u093f\\u092e\\u094b\\u0902 \\u0915\\u094b \\u0915\\u092e \\u0915\\u0930\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092d\\u0942\\u092e\\u093f\\u0915\\u093e \\u0928\\u093f\\u092d\\u093e\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\r\\n<p>&nbsp;<\\/p>\\r\\n\\r\\n<p>&nbsp;<\\/p>","ar":"<p>\\u062a\\u0634\\u064a\\u0631 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0625\\u0644\\u0649 \\u062a\\u0628\\u0627\\u062f\\u0644 \\u0627\\u0644\\u0633\\u0644\\u0639 \\u0623\\u0648 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0623\\u0648 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0634\\u0631\\u0643\\u0627\\u062a \\u0623\\u0648 \\u0627\\u0644\\u0643\\u064a\\u0627\\u0646\\u0627\\u062a \\u0641\\u064a \\u0633\\u064a\\u0627\\u0642 \\u0625\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u0623\\u0639\\u0645\\u0627\\u0644 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629. \\u062a\\u0639\\u062a\\u0628\\u0631 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0623\\u0645\\u0631\\u064b\\u0627 \\u0623\\u0633\\u0627\\u0633\\u064a\\u064b\\u0627 \\u0644\\u0648\\u0638\\u064a\\u0641\\u0629 \\u0627\\u0644\\u0627\\u0642\\u062a\\u0635\\u0627\\u062f \\u0648\\u062a\\u062e\\u0636\\u0639 \\u0644\\u0645\\u062e\\u062a\\u0644\\u0641 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0645\\u0628\\u0627\\u062f\\u0626. \\u0641\\u064a\\u0645\\u0627 \\u064a\\u0644\\u064a \\u0628\\u0639\\u0636 \\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0644\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629:<\\/p>\\r\\n\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p>\\u0623\\u0646\\u0648\\u0627\\u0639 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629: \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u0623\\u062e\\u0630 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0623\\u0634\\u0643\\u0627\\u0644\\u064b\\u0627 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0628\\u064a\\u0639 \\u0627\\u0644\\u0633\\u0644\\u0639\\u060c \\u0648\\u062a\\u0642\\u062f\\u064a\\u0645 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a\\u060c \\u0648\\u062a\\u0623\\u062c\\u064a\\u0631 \\u0623\\u0648 \\u062a\\u0623\\u062c\\u064a\\u0631 \\u0627\\u0644\\u0623\\u0635\\u0648\\u0644\\u060c \\u0648\\u0631\\u062e\\u0635 \\u0627\\u0644\\u0645\\u0644\\u0643\\u064a\\u0629 \\u0627\\u0644\\u0641\\u0643\\u0631\\u064a\\u0629\\u060c \\u0648\\u0634\\u0631\\u0627\\u0643\\u0627\\u062a \\u0627\\u0644\\u0623\\u0639\\u0645\\u0627\\u0644 \\u0627\\u0644\\u0645\\u0634\\u062a\\u0631\\u0643\\u0629\\u060c \\u0648\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u0627\\u0646\\u062f\\u0645\\u0627\\u062c \\u0648\\u0627\\u0644\\u0627\\u0633\\u062a\\u062d\\u0648\\u0627\\u0630\\u060c \\u0648\\u0627\\u062a\\u0641\\u0627\\u0642\\u064a\\u0627\\u062a \\u0627\\u0644\\u062a\\u0645\\u0648\\u064a\\u0644\\u060c \\u0648\\u0627\\u0644\\u0645\\u0632\\u064a\\u062f.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0627\\u062a\\u0641\\u0627\\u0642\\u064a\\u0627\\u062a \\u0627\\u0644\\u062a\\u0639\\u0627\\u0642\\u062f\\u064a\\u0629: \\u062a\\u064f\\u0639\\u0642\\u062f \\u0645\\u0639\\u0638\\u0645 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0627\\u062a\\u0641\\u0627\\u0642\\u064a\\u0627\\u062a \\u062a\\u0639\\u0627\\u0642\\u062f\\u064a\\u0629. \\u062a\\u062d\\u062f\\u062f \\u0627\\u0644\\u0639\\u0642\\u0648\\u062f \\u0634\\u0631\\u0648\\u0637 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u062d\\u0642\\u0648\\u0642 \\u0648\\u0627\\u0644\\u062a\\u0632\\u0627\\u0645\\u0627\\u062a \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u0627\\u0644\\u0645\\u0639\\u0646\\u064a\\u0629\\u060c \\u0648\\u0627\\u0644\\u062a\\u0633\\u0639\\u064a\\u0631\\u060c \\u0648\\u0634\\u0631\\u0648\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639\\u060c \\u0648\\u062c\\u062f\\u0627\\u0648\\u0644 \\u0627\\u0644\\u062a\\u0633\\u0644\\u064a\\u0645\\u060c \\u0648\\u0627\\u0644\\u0636\\u0645\\u0627\\u0646\\u0627\\u062a\\u060c \\u0648\\u0633\\u0628\\u0644 \\u0627\\u0644\\u062a\\u0635\\u062d\\u064a\\u062d \\u0641\\u064a \\u062d\\u0627\\u0644\\u0629 \\u0627\\u0644\\u062e\\u0631\\u0642.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0639\\u0631\\u0636 \\u0648\\u0627\\u0644\\u0642\\u0628\\u0648\\u0644: \\u062a\\u0628\\u062f\\u0623 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0639\\u0627\\u062f\\u0629\\u064b \\u0628\\u0642\\u064a\\u0627\\u0645 \\u0623\\u062d\\u062f \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u0628\\u062a\\u0642\\u062f\\u064a\\u0645 \\u0639\\u0631\\u0636 \\u0648\\u0642\\u0628\\u0648\\u0644 \\u0627\\u0644\\u0637\\u0631\\u0641 \\u0627\\u0644\\u0622\\u062e\\u0631. \\u0628\\u0645\\u062c\\u0631\\u062f \\u062a\\u0648\\u0627\\u0641\\u0642 \\u0627\\u0644\\u0623\\u0641\\u0643\\u0627\\u0631 (\\u0627\\u0644\\u0639\\u0631\\u0636 \\u0648\\u0627\\u0644\\u0642\\u0628\\u0648\\u0644)\\u060c \\u064a\\u062a\\u0645 \\u062a\\u0643\\u0648\\u064a\\u0646 \\u0627\\u062a\\u0641\\u0627\\u0642 \\u0642\\u0627\\u0646\\u0648\\u0646\\u064a \\u0642\\u0627\\u0626\\u0645.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0646\\u0638\\u0631: \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646\\u0635\\u0631 \\u062d\\u0627\\u0633\\u0645 \\u0641\\u064a \\u0627\\u0644\\u0639\\u0642\\u062f \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a. \\u0625\\u0646\\u0647 \\u064a\\u0634\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0642\\u064a\\u0645\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u0641\\u0627\\u0626\\u062f\\u0629 \\u0627\\u0644\\u062a\\u064a \\u064a\\u0639\\u062f \\u0643\\u0644 \\u0637\\u0631\\u0641 \\u0628\\u0623\\u0646 \\u064a\\u0639\\u0637\\u064a\\u0647\\u0627 \\u0623\\u0648 \\u064a\\u062a\\u0644\\u0642\\u0627\\u0647\\u0627 \\u0645\\u0642\\u0627\\u0628\\u0644 \\u0627\\u0644\\u062a\\u0632\\u0627\\u0645\\u0627\\u062a\\u0647\\u0645. \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u064a\\u0643\\u0648\\u0646 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0645\\u0627\\u0644\\u0627\\u064b\\u060c \\u0623\\u0648 \\u0633\\u0644\\u0639\\u064b\\u0627\\u060c \\u0623\\u0648 \\u062e\\u062f\\u0645\\u0627\\u062a\\u064d\\u060c \\u0623\\u0648 \\u0648\\u0639\\u062f\\u064b\\u0627 \\u0628\\u0627\\u0644\\u0642\\u064a\\u0627\\u0645 \\u0628\\u0634\\u064a\\u0621 \\u0623\\u0648 \\u0627\\u0644\\u0627\\u0645\\u062a\\u0646\\u0627\\u0639 \\u0639\\u0646 \\u0641\\u0639\\u0644\\u0647.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0623\\u062f\\u0627\\u0621 \\u0648\\u0627\\u0644\\u062a\\u0633\\u0644\\u064a\\u0645: \\u0628\\u0639\\u062f \\u062a\\u0643\\u0648\\u064a\\u0646 \\u0627\\u0644\\u0639\\u0642\\u062f\\u060c \\u064a\\u062a\\u0639\\u064a\\u0646 \\u0639\\u0644\\u0649 \\u0643\\u0644 \\u0637\\u0631\\u0641 \\u062a\\u0646\\u0641\\u064a\\u0630 \\u062c\\u0632\\u0621\\u0647 \\u0645\\u0646 \\u0627\\u0644\\u0635\\u0641\\u0642\\u0629. \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u064a\\u0634\\u0645\\u0644 \\u0630\\u0644\\u0643 \\u062a\\u0633\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0633\\u0644\\u0639\\u060c \\u0648\\u062a\\u0642\\u062f\\u064a\\u0645 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a\\u060c \\u0648\\u0625\\u062c\\u0631\\u0627\\u0621 \\u0627\\u0644\\u062f\\u0641\\u0639\\u0627\\u062a\\u060c \\u0623\\u0648 \\u062a\\u062d\\u0642\\u064a\\u0642 \\u0627\\u0644\\u062a\\u0632\\u0627\\u0645\\u0627\\u062a \\u0623\\u062e\\u0631\\u0649 \\u0643\\u0645\\u0627 \\u0647\\u0648 \\u0645\\u062d\\u062f\\u062f \\u0641\\u064a \\u0627\\u0644\\u0639\\u0642\\u062f.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0645\\u062e\\u0627\\u0637\\u0631 \\u0648\\u0627\\u0644\\u0645\\u0644\\u0643\\u064a\\u0629: \\u0641\\u064a \\u0633\\u064a\\u0627\\u0642 \\u0628\\u064a\\u0639 \\u0627\\u0644\\u0633\\u0644\\u0639\\u060c \\u0641\\u0625\\u0646 \\u0645\\u0641\\u0647\\u0648\\u0645 \\u0646\\u0642\\u0644 \\u0627\\u0644\\u0645\\u062e\\u0627\\u0637\\u0631 \\u0648\\u0627\\u0644\\u0645\\u0644\\u0643\\u064a\\u0629 \\u0623\\u0645\\u0631 \\u0623\\u0633\\u0627\\u0633\\u064a. \\u0625\\u0646\\u0647 \\u064a\\u062d\\u062f\\u062f \\u0645\\u062a\\u0649 \\u064a\\u0646\\u062a\\u0642\\u0644 \\u0645\\u0644\\u0643\\u064a\\u0629 \\u0627\\u0644\\u0633\\u0644\\u0639 \\u0648\\u0627\\u0644\\u0645\\u062e\\u0627\\u0637\\u0631\\u0629 \\u0628\\u0627\\u0644\\u062e\\u0633\\u0627\\u0631\\u0629 \\u0623\\u0648 \\u0627\\u0644\\u0636\\u0631\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0628\\u0627\\u0626\\u0639 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0634\\u062a\\u0631\\u064a.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u062f\\u0641\\u0639 \\u0648\\u0627\\u0644\\u062a\\u0645\\u0648\\u064a\\u0644: \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062e\\u062a\\u0644\\u0641 \\u0634\\u0631\\u0648\\u0637 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0641\\u0648\\u0631\\u064a\\u060c \\u0648\\u0627\\u0644\\u062f\\u0641\\u0639\\u0627\\u062a \\u0627\\u0644\\u0628\\u0646\\u062f\\u064a\\u0629\\u060c \\u0623\\u0648 \\u0627\\u0644\\u062a\\u0631\\u062a\\u064a\\u0628\\u0627\\u062a \\u0627\\u0644\\u0627\\u0626\\u062a\\u0645\\u0627\\u0646\\u064a\\u0629. \\u0642\\u062f \\u064a\\u0643\\u0648\\u0646 \\u0647\\u0646\\u0627\\u0643 \\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0644\\u0627\\u062a\\u0641\\u0627\\u0642\\u0627\\u062a \\u0627\\u0644\\u062a\\u0645\\u0648\\u064a\\u0644 \\u0644\\u062a\\u064a\\u0633\\u064a\\u0631 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629\\u060c \\u062e\\u0627\\u0635\\u0629 \\u0641\\u064a \\u0635\\u0641\\u0642\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0629 \\u0628\\u0643\\u0628\\u0631\\u0649.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0633\\u0628\\u0644 \\u062a\\u0635\\u062d\\u064a\\u062d \\u0627\\u0644\\u062e\\u0631\\u0642: \\u0625\\u0630\\u0627 \\u0641\\u0634\\u0644 \\u0623\\u062d\\u062f \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u0641\\u064a \\u062a\\u062d\\u0642\\u064a\\u0642 \\u0627\\u0644\\u062a\\u0632\\u0627\\u0645\\u0627\\u062a\\u0647\\u0627 \\u0641\\u064a \\u0627\\u0644\\u0639\\u0642\\u062f (\\u062e\\u0631\\u0642)\\u060c \\u0641\\u0642\\u062f \\u064a\\u0643\\u0648\\u0646 \\u0644\\u062f\\u0649 \\u0627\\u0644\\u0637\\u0631\\u0641 \\u0627\\u0644\\u063a\\u064a\\u0631 \\u0645\\u062e\\u062a\\u0631\\u0642 \\u0627\\u0644\\u0639\\u062f\\u064a\\u062f \\u0645\\u0646 \\u0627\\u0644\\u0648\\u0633\\u0627\\u0626\\u0644\\u060c \\u0645\\u062b\\u0644 \\u0637\\u0644\\u0628 \\u0627\\u0644\\u062a\\u0639\\u0648\\u064a\\u0636\\u0627\\u062a\\u060c \\u0623\\u0648 \\u0627\\u0644\\u0623\\u062f\\u0627\\u0621 \\u0627\\u0644\\u062e\\u0627\\u0635 (\\u0641\\u0631\\u0636 \\u0627\\u0644\\u0637\\u0631\\u0641 \\u0627\\u0644\\u0622\\u062e\\u0631 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0623\\u062f\\u0627\\u0621 \\u0643\\u0645\\u0627 \\u0648\\u0639\\u062f)\\u060c \\u0623\\u0648 \\u0625\\u0646\\u0647\\u0627\\u0621 \\u0627\\u0644\\u0639\\u0642\\u062f.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0627\\u0644\\u062a\\u0646\\u0638\\u064a\\u0645\\u064a: \\u0642\\u062f \\u062a\\u062e\\u0636\\u0639 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0648\\u0644\\u0648\\u0627\\u0626\\u062d \\u0645\\u062d\\u062f\\u062f\\u0629\\u060c \\u0627\\u0639\\u062a\\u0645\\u0627\\u062f\\u064b\\u0627 \\u0639\\u0644\\u0649 \\u0637\\u0628\\u064a\\u0639\\u0629 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0629 \\u0648\\u0627\\u0644\\u0635\\u0646\\u0627\\u0639\\u0629 \\u0627\\u0644\\u0645\\u0639\\u0646\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0633\\u0644\\u0637\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u062a\\u0639\\u0645\\u0644 \\u0641\\u064a\\u0647\\u0627 \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641. \\u0625\\u0646 \\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0628\\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0623\\u0645\\u0631 \\u0623\\u0633\\u0627\\u0633\\u064a \\u0644\\u062a\\u062c\\u0646\\u0628 \\u0627\\u0644\\u0645\\u0634\\u0627\\u0643\\u0644 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0639\\u0642\\u0648\\u0628\\u0627\\u062a.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0633\\u0631\\u064a\\u0629 \\u0648\\u0639\\u062f\\u0645 \\u0627\\u0644\\u0643\\u0634\\u0641: \\u0641\\u064a \\u0628\\u0639\\u0636 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629\\u060c \\u0642\\u062f \\u062a\\u062d\\u062a\\u0627\\u062c \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u0625\\u0644\\u0649 \\u062a\\u0628\\u0627\\u062f\\u0644 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u062d\\u0633\\u0627\\u0633\\u0629. \\u064a\\u0645\\u0643\\u0646 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u062a\\u0641\\u0627\\u0642\\u064a\\u0627\\u062a \\u0639\\u062f\\u0645 \\u0627\\u0644\\u0643\\u0634\\u0641 (NDA) \\u0644\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0633\\u0631\\u064a\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0643\\u0634\\u0641 \\u0644\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u0627\\u0644\\u062b\\u0627\\u0644\\u062b\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0627\\u0644\\u062f\\u0648\\u0644\\u064a\\u0629: \\u062a\\u0634\\u0645\\u0644 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u062d\\u062f\\u0648\\u062f \\u062a\\u0639\\u0642\\u064a\\u062f\\u0627\\u062a \\u0625\\u0636\\u0627\\u0641\\u064a\\u0629 \\u0628\\u0633\\u0628\\u0628 \\u0627\\u0644\\u0623\\u0646\\u0638\\u0645\\u0629 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062e\\u062a\\u0644\\u0641\\u0629\\u060c \\u0648\\u0627\\u0644\\u0641\\u0631\\u0648\\u0642 \\u0627\\u0644\\u062b\\u0642\\u0627\\u0641\\u064a\\u0629\\u060c \\u0648\\u062d\\u0648\\u0627\\u062c\\u0632 \\u0627\\u0644\\u0644\\u063a\\u0629\\u060c \\u0648\\u062a\\u0646\\u0638\\u064a\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u0629 \\u0627\\u0644\\u062f\\u0648\\u0644\\u064a\\u0629.<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n\\r\\n<p>\\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0623\\u0645\\u0631 \\u0628\\u0627\\u0644\\u063a \\u0627\\u0644\\u0623\\u0647\\u0645\\u064a\\u0629 \\u0644\\u0646\\u0645\\u0648 \\u0627\\u0644\\u0623\\u0639\\u0645\\u0627\\u0644 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629\\u060c \\u0648\\u062a\\u0648\\u0633\\u064a\\u0639 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a\\u0647\\u0627\\u060c \\u0648\\u062a\\u0639\\u0632\\u064a\\u0632 \\u0627\\u0644\\u062a\\u0646\\u0645\\u064a\\u0629 \\u0627\\u0644\\u0627\\u0642\\u062a\\u0635\\u0627\\u062f\\u064a\\u0629. \\u0645\\u0646 \\u0627\\u0644\\u0636\\u0631\\u0648\\u0631\\u064a \\u0623\\u0646 \\u064a\\u062a\\u0645 \\u0625\\u062c\\u0631\\u0627\\u0621 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0628\\u0648\\u0636\\u0648\\u062d \\u0648\\u0634\\u0641\\u0627\\u0641\\u064a\\u0629 \\u0648\\u0628\\u0645\\u0631\\u0627\\u0639\\u0627\\u0629 \\u0644\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0630\\u0627\\u062a \\u0627\\u0644\\u0635\\u0644\\u0629 \\u0644\\u0636\\u0645\\u0627\\u0646 \\u0646\\u062c\\u0627\\u062d \\u0627\\u0644\\u0623\\u0639\\u0645\\u0627\\u0644 \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0648\\u0627\\u0633\\u062a\\u062f\\u0627\\u0645\\u062a\\u0647\\u0627 \\u0641\\u064a \\u0627\\u0644\\u0633\\u0648\\u0642. \\u062a\\u0644\\u0639\\u0628 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0634\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0639\\u0646\\u0627\\u064a\\u0629 \\u0627\\u0644\\u062f\\u0642\\u064a\\u0642\\u0629 \\u062f\\u0648\\u0631\\u064b\\u0627 \\u062d\\u064a\\u0648\\u064a\\u064b\\u0627 \\u0641\\u064a \\u062a\\u064a\\u0633\\u064a\\u0631 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0627\\u0644\\u0633\\u0644\\u0633\\u0629 \\u0648\\u062a\\u0642\\u0644\\u064a\\u0644 \\u0627\\u0644\\u0645\\u062e\\u0627\\u0637\\u0631 \\u0627\\u0644\\u0645\\u062d\\u062a\\u0645\\u0644\\u0629.<\\/p>\\r\\n\\r\\n<p>&nbsp;<\\/p>\\r\\n\\r\\n<p>&nbsp;<\\/p>"}',
                'icon' => '/images/therapist_main_categories/64cb8880688c8.png',
                'id' => 3,
                'image' => '/images/therapist_main_categories/64cb8880682df.png',
                'is_active' => 1,
                'is_featured' => 1,
                'name' => '{"en":"Commercial Transactions","hi":"\\u0935\\u094d\\u092f\\u0935\\u0938\\u093e\\u092f\\u093f\\u0915 \\u0932\\u0947\\u0928\\u0926\\u0947\\u0928","ar":"\\u0627\\u0644\\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0627\\u0631\\u064a\\u0629"}',
                'slug' => 'vayavasayaka-lnathana-3',
                'updated_at' => '2023-10-10 19:16:13',
            ),
            3 => 
            array (
                'created_at' => '2023-08-03 14:05:54',
                'deleted_at' => NULL,
            'description' => '{"en":"<p>Family Therapy Mediation is a process in which a neutral third party, known as a mediator, helps couples or family members in conflict to communicate, negotiate, and reach agreements on various family-related issues. This alternative dispute resolution method aims to facilitate open dialogue and collaboration, enabling the parties to find mutually acceptable solutions without going to court.<\\/p>\\r\\n\\r\\n<p>Key Aspects of Family Therapy Mediation:<\\/p>\\r\\n\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p>Family-Related Issues: Family therapy mediation can cover a wide range of disputes, including divorce and separation, child custody and visitation, child support, spousal support (alimony), property division, and parenting plans.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Neutral Mediator: The mediator is an impartial facilitator who does not take sides or make decisions for the parties. Their role is to assist in identifying common interests, fostering communication, and guiding the parties toward reaching agreements.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Voluntary Process: Participation in family therapy mediation is usually voluntary. Both parties must agree to engage in the mediation process willingly. However, in some jurisdictions, mediation may be court-ordered or mandated before proceeding to litigation.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Confidentiality: Mediation proceedings are confidential, which means that discussions, negotiations, and any proposals made during the mediation process cannot be used as evidence in court if the mediation does not result in a settlement.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Focus on Interests and Needs: Mediation encourages participants to focus on their interests, needs, and those of their children, rather than taking adversarial positions. This approach can lead to more customized and workable solutions.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Better Communication: Family therapy mediation promotes better communication between the parties, reducing hostility and animosity, which can be especially important in maintaining a healthy co-parenting relationship after divorce or separation.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Efficient and Cost-Effective: Mediation can be a faster and more cost-effective alternative to traditional court proceedings. It allows the parties to have more control over the outcome and can help prevent protracted and expensive litigation.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Legal Review: After reaching agreements through mediation, the parties may choose to have their mediated agreement reviewed by their respective attorneys before finalizing and submitting it to the court for approval.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Compliance and Enforcement: Once the mediated agreement is court-approved, it becomes a legally binding contract, and the parties must adhere to its terms. If a party fails to comply with the agreement, the other party can seek enforcement through the court.<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n\\r\\n<p>Family therapy mediation is considered a valuable tool for resolving disputes amicably, especially in emotionally charged family matters. It empowers individuals to actively participate in the decision-making process, fosters a more cooperative atmosphere, and helps preserve relationships while addressing important family-related issues. However, it may not be suitable for all cases, especially when there is a history of abuse or severe power imbalances between the parties. In such cases, other legal avenues, like litigation, may be more appropriate.<\\/p>\\r\\n\\r\\n<p>&nbsp;<\\/p>\\r\\n\\r\\n<p>&nbsp;<\\/p>","hi":"<p>\\u0915\\u0941\\u0932 \\u0928\\u094d\\u092f\\u093e\\u092f\\u093f\\u0915 \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u0940 \\u0935\\u093f\\u0935\\u093e\\u0926-\\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u0923 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0939\\u0948 \\u091c\\u093f\\u0938\\u092e\\u0947\\u0902 \\u090f\\u0915 \\u0924\\u093f\\u0938\\u0930\\u093e \\u0928\\u093f\\u0937\\u094d\\u092a\\u0915\\u094d\\u0937 \\u092a\\u0915\\u094d\\u0937, \\u091c\\u093f\\u0938\\u0947 \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u0940 \\u0915\\u0939\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948, \\u0935\\u093f\\u0935\\u093e\\u0926\\u093f\\u0924 \\u092f\\u093e \\u092a\\u0930\\u093f\\u0935\\u093e\\u0930 \\u0915\\u0947 \\u0938\\u0926\\u0938\\u094d\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0938\\u0902\\u0935\\u093e\\u0926 \\u0915\\u0930\\u0928\\u0947, \\u0935\\u093e\\u0930\\u094d\\u0924\\u093e \\u0915\\u0930\\u0928\\u0947 \\u0914\\u0930 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u092a\\u0930\\u093f\\u0935\\u093e\\u0930-\\u0938\\u0902\\u092c\\u0902\\u0927\\u0940 \\u092e\\u0941\\u0926\\u094d\\u0926\\u094b\\u0902 \\u092a\\u0930 \\u0938\\u092e\\u091d\\u094c\\u0924\\u094b\\u0902 \\u092a\\u0930 \\u092a\\u0939\\u0941\\u0901\\u091a\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u092e\\u0926\\u0926 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0939 \\u0935\\u0948\\u0915\\u0932\\u094d\\u092a\\u093f\\u0915 \\u0935\\u093f\\u0935\\u093e\\u0926-\\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u0923 \\u0935\\u093f\\u0927\\u093f \\u0915\\u093e \\u0909\\u0926\\u094d\\u0926\\u0947\\u0936\\u094d\\u092f \\u0938\\u093e\\u0916\\u094d\\u092f\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0938\\u0902\\u0935\\u093e\\u0926 \\u0914\\u0930 \\u0938\\u0939\\u092f\\u094b\\u0917 \\u0915\\u094b \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e\\u091c\\u0928\\u0915 \\u092c\\u0928\\u093e\\u0928\\u093e \\u0939\\u0948, \\u091c\\u093f\\u0938\\u0938\\u0947 \\u092a\\u0915\\u094d\\u0937 \\u0905\\u0926\\u093e\\u0932\\u0924 \\u092e\\u0947\\u0902 \\u0928 \\u091c\\u093e\\u090f\\u0902\\u0964<\\/p>\\r\\n\\r\\n<p>\\u0915\\u0941\\u0932 \\u092a\\u0930\\u093f\\u0935\\u093e\\u0930 \\u0935\\u093f\\u0927\\u093f\\u0915 \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u0940 \\u0915\\u0947 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092a\\u0939\\u0932\\u0941\\u090f\\u0901:<\\/p>\\r\\n\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u092a\\u0930\\u093f\\u0935\\u093e\\u0930-\\u0938\\u0902\\u092c\\u0902\\u0927\\u0940 \\u092e\\u0941\\u0926\\u094d\\u0926\\u0947: \\u092a\\u0930\\u093f\\u0935\\u093e\\u0930 \\u0935\\u093f\\u0927\\u093f\\u0915 \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u0940 \\u0924\\u0932\\u093e\\u0915 \\u0914\\u0930 \\u0905\\u0932\\u0917\\u093e\\u0935, \\u092c\\u091a\\u094d\\u091a\\u0947 \\u0915\\u0940 \\u0939\\u0915 \\u0930\\u093e\\u092f \\u0914\\u0930 \\u092e\\u093f\\u0932\\u0928, \\u092c\\u091a\\u094d\\u091a\\u0947 \\u0915\\u093e \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928, \\u0938\\u093e\\u0925\\u0940 \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 (\\u0928\\u092b\\u093e), \\u0938\\u0902\\u092a\\u0924\\u094d\\u0924\\u093f \\u0935\\u093f\\u092d\\u093e\\u091c\\u0928 \\u0914\\u0930 \\u092e\\u093e\\u0924\\u0943\\u092a\\u093f\\u0924\\u0943 \\u092f\\u094b\\u091c\\u0928\\u093e\\u090f\\u0901 \\u091c\\u0948\\u0938\\u0947 \\u0935\\u093f\\u0935\\u093e\\u0926\\u094b\\u0902 \\u0915\\u093e \\u0935\\u094d\\u092f\\u093e\\u092a\\u0915 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930 \\u0915\\u0935\\u0930 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u0928\\u093f\\u0937\\u094d\\u092a\\u0915\\u094d\\u0937 \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u0940: \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u0940 \\u090f\\u0915 \\u0928\\u093f\\u0937\\u094d\\u092a\\u0915\\u094d\\u0937 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e\\u0915\\u0930\\u094d\\u0924\\u093e \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948 \\u091c\\u094b \\u092a\\u0915\\u094d\\u0937\\u094b\\u0902 \\u0915\\u0940 \\u0924\\u0930\\u092b \\u0928\\u0939\\u0940\\u0902 \\u0932\\u0947\\u0924\\u093e \\u0914\\u0930 \\u0909\\u0928\\u0915\\u0947 \\u0932\\u093f\\u090f \\u0928\\u093f\\u0930\\u094d\\u0923\\u092f \\u0928\\u0939\\u0940\\u0902 \\u0932\\u0947\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0909\\u0928\\u0915\\u0940 \\u092d\\u0942\\u092e\\u093f\\u0915\\u093e \\u0938\\u093e\\u092e\\u093e\\u0928\\u094d\\u092f \\u0939\\u093f\\u0924\\u094b\\u0902 \\u0915\\u0940 \\u092a\\u0939\\u091a\\u093e\\u0928 \\u092e\\u0947\\u0902 \\u0938\\u0939\\u093e\\u092f\\u0915 \\u0915\\u0930\\u0928\\u093e, \\u0938\\u0902\\u0935\\u093e\\u0926 \\u0915\\u094b \\u092c\\u0922\\u093c\\u093e\\u0935\\u093e \\u0926\\u0947\\u0928\\u093e \\u0914\\u0930 \\u092a\\u0915\\u094d\\u0937\\u094b\\u0902 \\u0915\\u094b \\u0938\\u092e\\u091d\\u094c\\u0924\\u094b\\u0902 \\u092a\\u0930 \\u092a\\u0939\\u0941\\u0901\\u091a\\u0928\\u0947 \\u0915\\u0940 \\u0926\\u093f\\u0936\\u093e \\u092e\\u0947\\u0902 \\u092e\\u093e\\u0930\\u094d\\u0917\\u0926\\u0930\\u094d\\u0936\\u0928 \\u0915\\u0930\\u0928\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u0938\\u094d\\u0935\\u0947\\u091a\\u094d\\u091b\\u093e\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e: \\u092a\\u0930\\u093f\\u0935\\u093e\\u0930 \\u0935\\u093f\\u0927\\u093f\\u0915 \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u0940 \\u092e\\u0947\\u0902 \\u092d\\u093e\\u0917 \\u0932\\u0947\\u0928\\u093e \\u0906\\u092e\\u0924\\u094c\\u0930 \\u092a\\u0930 \\u0938\\u094d\\u0935\\u0947\\u091a\\u094d\\u091b\\u093e\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0926\\u094b\\u0928\\u094b\\u0902 \\u092a\\u0915\\u094d\\u0937\\u094b\\u0902 \\u0915\\u094b \\u0938\\u094d\\u0935\\u0947\\u091a\\u094d\\u091b\\u093e \\u0938\\u0947 \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u0940 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u092e\\u0947\\u0902 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u094b\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0938\\u0939\\u092e\\u0924 \\u0939\\u094b\\u0928\\u093e \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915 \\u0939\\u0948\\u0964 \\u0939\\u093e\\u0932\\u093e\\u0902\\u0915\\u093f, \\u0915\\u0941\\u091b \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930\\u094b\\u0902 \\u092e\\u0947\\u0902, \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u0940 \\u0915\\u094b \\u0928\\u094d\\u092f\\u093e\\u092f\\u093e\\u0932\\u092f \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0906\\u0926\\u0947\\u0936 \\u0926\\u093f\\u092f\\u093e \\u091c\\u093e \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948 \\u092f\\u093e \\u092f\\u0939 \\u0935\\u093f\\u0935\\u093e\\u0926-\\u092e\\u0941\\u0915\\u0926\\u092e\\u0947 \\u0915\\u0940 \\u0926\\u093f\\u0936\\u093e \\u092e\\u0947\\u0902 \\u0906\\u0917\\u0947 \\u092c\\u0922\\u093c\\u0928\\u0947 \\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947 \\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u093f\\u0924 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e: \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u0940 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e\\u090f\\u0901 \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f \\u0939\\u094b\\u0924\\u0940 \\u0939\\u0948\\u0902, \\u091c\\u093f\\u0938\\u0915\\u093e \\u0905\\u0930\\u094d\\u0925 \\u0939\\u0948 \\u0915\\u093f \\u092f\\u0926\\u093f \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u0940 \\u0938\\u092e\\u091d\\u094c\\u0924\\u093e \\u0928\\u0939\\u0940\\u0902 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u0924\\u094b \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u0940 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u0947 \\u0926\\u094c\\u0930\\u093e\\u0928 \\u0939\\u0941\\u0908 \\u091a\\u0930\\u094d\\u091a\\u093e\\u090f\\u0901, \\u0935\\u093e\\u0930\\u094d\\u0924\\u093e \\u0914\\u0930 \\u0915\\u094b\\u0908 \\u092a\\u094d\\u0930\\u0938\\u094d\\u0924\\u093e\\u0935 \\u0928\\u094d\\u092f\\u093e\\u092f\\u093e\\u0932\\u092f \\u092e\\u0947\\u0902 \\u0938\\u092c\\u0942\\u0924 \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u0909\\u092a\\u092f\\u094b\\u0917 \\u0928\\u0939\\u0940\\u0902 \\u0915\\u0940 \\u091c\\u093e \\u0938\\u0915\\u0924\\u0940 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u0939\\u093f\\u0924\\u094b\\u0902 \\u0914\\u0930 \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e\\u0913\\u0902 \\u092a\\u0930 \\u0927\\u094d\\u092f\\u093e\\u0928 \\u0915\\u0947\\u0902\\u0926\\u094d\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0928\\u093e: \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u0940 \\u0938\\u092e\\u093e\\u0927\\u093e\\u0928 \\u0938\\u0902\\u0935\\u093e\\u0926 \\u0915\\u0930\\u0928\\u0947 \\u0935\\u093e\\u0932\\u094b\\u0902 \\u0915\\u094b \\u0909\\u0928\\u0915\\u0947 \\u0939\\u093f\\u0924\\u094b\\u0902, \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915\\u0924\\u093e\\u0913\\u0902 \\u0914\\u0930 \\u0909\\u0928\\u0915\\u0947 \\u092c\\u091a\\u094d\\u091a\\u094b\\u0902 \\u0915\\u0947 \\u0939\\u093f\\u0924\\u094b\\u0902 \\u092a\\u0930 \\u0927\\u094d\\u092f\\u093e\\u0928 \\u0915\\u0947\\u0902\\u0926\\u094d\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092a\\u094d\\u0930\\u0947\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948, \\u092c\\u093f\\u0930\\u094b\\u0927\\u0940 \\u092a\\u094b\\u091c\\u093f\\u0936\\u0928 \\u0928 \\u0932\\u0947\\u0928\\u0947 \\u0915\\u0940 \\u092c\\u091c\\u093e\\u092f\\u0964 \\u092f\\u0939 \\u0926\\u0943\\u0937\\u094d\\u091f\\u093f\\u0915\\u094b\\u0923 \\u0905\\u0927\\u093f\\u0915 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u0917\\u0924 \\u0914\\u0930 \\u0915\\u093e\\u0930\\u094d\\u092f\\u0915\\u094d\\u0937\\u092e \\u0938\\u092e\\u093e\\u0927\\u093e\\u0928\\u094b\\u0902 \\u0915\\u0940 \\u0913\\u0930 \\u092a\\u0939\\u0941\\u0901\\u091a\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092c\\u0922\\u093c\\u093e\\u0935\\u093e \\u0926\\u0947 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u092c\\u0947\\u0939\\u0924\\u0930 \\u0938\\u0902\\u0935\\u093e\\u0926: \\u092a\\u0930\\u093f\\u0935\\u093e\\u0930 \\u0935\\u093f\\u0927\\u093f\\u0915 \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u0940 \\u092a\\u0915\\u094d\\u0937\\u094b\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u092c\\u0947\\u0939\\u0924\\u0930 \\u0938\\u0902\\u0935\\u093e\\u0926 \\u0915\\u094b \\u092a\\u094d\\u0930\\u094b\\u0924\\u094d\\u0938\\u093e\\u0939\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948, \\u0926\\u0941\\u0936\\u094d\\u092e\\u0928\\u0940 \\u0914\\u0930 \\u0926\\u0941\\u0936\\u094d\\u092e\\u0928\\u0940 \\u0915\\u094b \\u0915\\u092e \\u0915\\u0930\\u0924\\u0940 \\u0939\\u0948, \\u091c\\u094b \\u0924\\u0932\\u093e\\u0915 \\u092f\\u093e \\u0905\\u0932\\u0917\\u093e\\u0935 \\u0915\\u0947 \\u092c\\u093e\\u0926 \\u090f\\u0915 \\u0938\\u094d\\u0935\\u0938\\u094d\\u0925 \\u0938\\u0939-\\u092e\\u093e\\u0924\\u0943\\u092a\\u093f\\u0924\\u0943 \\u0938\\u0902\\u092c\\u0902\\u0927 \\u092c\\u0928\\u093e\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u0915\\u0941\\u0936\\u0932 \\u0914\\u0930 \\u0932\\u093e\\u0917\\u0924-\\u0915\\u0941\\u0936\\u0932: \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u0940 \\u092a\\u093e\\u0930\\u0902\\u092a\\u0930\\u093f\\u0915 \\u0928\\u094d\\u092f\\u093e\\u092f\\u093f\\u0915 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0915\\u0947 \\u0924\\u0941\\u0932\\u0928\\u093e \\u092e\\u0947\\u0902 \\u090f\\u0915 \\u0924\\u0947\\u091c \\u0914\\u0930 \\u0932\\u093e\\u0917\\u0924-\\u0915\\u0941\\u0936\\u0932 \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964 \\u092f\\u0939 \\u092a\\u0915\\u094d\\u0937\\u094b\\u0902 \\u0915\\u094b \\u092a\\u0930\\u093f\\u0923\\u093e\\u092e \\u092a\\u0930 \\u0905\\u0927\\u093f\\u0915 \\u0928\\u093f\\u092f\\u0902\\u0924\\u094d\\u0930\\u0923 \\u0926\\u0947\\u0928\\u0947 \\u0926\\u0947\\u0924\\u093e \\u0939\\u0948 \\u0914\\u0930 \\u0926\\u0940\\u0930\\u094d\\u0918\\u0915\\u093e\\u0932\\u093f\\u0915 \\u0914\\u0930 \\u092e\\u0939\\u0902\\u0917\\u0947 \\u0935\\u093f\\u0935\\u093e\\u0926 \\u0915\\u094b \\u0930\\u094b\\u0915\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u092e\\u0926\\u0926 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u0928\\u094d\\u092f\\u093e\\u092f\\u093f\\u0915 \\u0938\\u092e\\u0940\\u0915\\u094d\\u0937\\u093e: \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u0940 \\u0915\\u0947 \\u092e\\u093e\\u0927\\u094d\\u092f\\u092e \\u0938\\u0947 \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 \\u092a\\u0930 \\u092a\\u0939\\u0941\\u0901\\u091a\\u0928\\u0947 \\u0915\\u0947 \\u092c\\u093e\\u0926, \\u092a\\u0915\\u094d\\u0937\\u094b\\u0902 \\u0915\\u094b \\u0906\\u092e\\u0924\\u094c\\u0930 \\u092a\\u0930 \\u0928\\u094d\\u092f\\u093e\\u092f\\u093f\\u0915 \\u0935\\u0915\\u0940\\u0932\\u094b\\u0902 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u091c\\u093e\\u0902\\u091a \\u0915\\u0930\\u0928\\u0947 \\u0915\\u093e \\u0935\\u093f\\u0915\\u0932\\u094d\\u092a \\u0939\\u094b\\u0924\\u093e \\u0939\\u0948 \\u0914\\u0930 \\u092b\\u093f\\u0930 \\u0907\\u0938\\u0947 \\u0928\\u094d\\u092f\\u093e\\u092f\\u093e\\u0932\\u092f \\u0915\\u094b \\u0938\\u094d\\u0935\\u0940\\u0915\\u0943\\u0924\\u093f \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u0902\\u0924\\u093f\\u092e \\u0930\\u0942\\u092a \\u0926\\u0947\\u0928\\u0947 \\u0914\\u0930 \\u092a\\u094d\\u0930\\u0938\\u094d\\u0924\\u0941\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0938\\u0947 \\u092a\\u0939\\u0932\\u0947\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t\\t<p>\\u0906\\u091c\\u094d\\u091e\\u093e\\u0928\\u0941\\u0936\\u093e\\u0938\\u0928 \\u0914\\u0930 \\u092a\\u093e\\u0932\\u0928: \\u091c\\u092c \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u093f\\u0924 \\u0938\\u092e\\u091d\\u094c\\u0924\\u093e \\u0928\\u094d\\u092f\\u093e\\u092f\\u093f\\u0915 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u0938\\u094d\\u0935\\u0940\\u0915\\u0943\\u0924 \\u0939\\u094b \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948, \\u0924\\u094b \\u092f\\u0939 \\u0935\\u093f\\u0927\\u093f\\u0915 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092c\\u093e\\u0927\\u094d\\u092f \\u0915\\u0930\\u0928\\u0947 \\u092f\\u094b\\u0917\\u094d\\u092f \\u090f\\u0915 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0938\\u092e\\u091d\\u094c\\u0924\\u093e \\u092c\\u0928 \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948, \\u0914\\u0930 \\u092a\\u0915\\u094d\\u0937\\u094b\\u0902 \\u0915\\u094b \\u0907\\u0938\\u0915\\u0947 \\u0936\\u0930\\u094d\\u0924\\u094b\\u0902 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0915\\u0930\\u0928\\u093e \\u0906\\u0935\\u0936\\u094d\\u092f\\u0915 \\u0939\\u0948\\u0964 \\u092f\\u0926\\u093f \\u0915\\u094b\\u0908 \\u092a\\u0915\\u094d\\u0937 \\u0906\\u092e\\u0924\\u094c\\u0930 \\u092a\\u0930 \\u0938\\u092e\\u091d\\u094c\\u0924\\u0947 \\u0915\\u093e \\u092a\\u093e\\u0932\\u0928 \\u0928\\u0939\\u0940\\u0902 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u0924\\u094b \\u0926\\u0942\\u0938\\u0930\\u0947 \\u092a\\u0915\\u094d\\u0937 \\u0915\\u094b \\u0928\\u094d\\u092f\\u093e\\u092f\\u093f\\u0915 \\u0926\\u094d\\u0935\\u093e\\u0930\\u093e \\u0909\\u0928\\u094d\\u0939\\u0947\\u0902 \\u0932\\u093e\\u0917\\u0942 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u092a\\u094d\\u0930\\u092f\\u093e\\u0938 \\u0915\\u0930 \\u0938\\u0915\\u0924\\u093e \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n\\r\\n<p>\\u092a\\u0930\\u093f\\u0935\\u093e\\u0930 \\u0935\\u093f\\u0927\\u093f\\u0915 \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u0940 \\u0915\\u094b \\u0935\\u093f\\u0935\\u093e\\u0926\\u094b\\u0902 \\u0915\\u094b \\u092e\\u093f\\u0924\\u094d\\u0930\\u0936\\u0940\\u0932\\u0924\\u093e \\u0938\\u0947 \\u0938\\u0941\\u0932\\u091d\\u093e\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u090f\\u0915 \\u092e\\u0942\\u0932\\u094d\\u092f\\u0935\\u0930\\u094d\\u0927\\u093f\\u0924 \\u0909\\u092a\\u0915\\u0930\\u0923 \\u0915\\u0947 \\u0930\\u0942\\u092a \\u092e\\u0947\\u0902 \\u0935\\u093f\\u091a\\u093e\\u0930 \\u0915\\u093f\\u092f\\u093e \\u091c\\u093e\\u0924\\u093e \\u0939\\u0948, \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092d\\u093e\\u0935\\u0928\\u093e\\u0924\\u094d\\u092e\\u0915 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092d\\u0930\\u092a\\u0942\\u0930 \\u092a\\u0930\\u093f\\u0935\\u093e\\u0930\\u093f\\u0915 \\u092e\\u0941\\u0926\\u094d\\u0926\\u094b\\u0902 \\u092e\\u0947\\u0902\\u0964 \\u092f\\u0939 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0928\\u093f\\u0930\\u094d\\u0923\\u092f \\u0928\\u093f\\u0930\\u094d\\u092e\\u093e\\u0923 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u092e\\u0947\\u0902 \\u0938\\u0915\\u094d\\u0930\\u093f\\u092f \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092d\\u093e\\u0917 \\u0932\\u0947\\u0928\\u0947 \\u0915\\u0940 \\u0936\\u0915\\u094d\\u0924\\u093f \\u092a\\u094d\\u0930\\u0926\\u093e\\u0928 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u0938\\u0939\\u092f\\u094b\\u0917\\u0940 \\u0935\\u093e\\u0924\\u093e\\u0935\\u0930\\u0923 \\u0915\\u094b \\u092c\\u0922\\u093c\\u093e\\u0935\\u093e \\u0926\\u0947\\u0924\\u093e \\u0939\\u0948, \\u0914\\u0930 \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u092a\\u0930\\u093f\\u0935\\u093e\\u0930-\\u0938\\u0902\\u092c\\u0902\\u0927\\u0940 \\u092e\\u0941\\u0926\\u094d\\u0926\\u094b\\u0902 \\u0915\\u093e \\u0938\\u092e\\u093e\\u0927\\u093e\\u0928 \\u0915\\u0930\\u0924\\u0947 \\u0938\\u092e\\u092f \\u0938\\u0902\\u092c\\u0902\\u0927\\u094b\\u0902 \\u0915\\u094b \\u0938\\u0902\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u092e\\u0947\\u0902 \\u092e\\u0926\\u0926 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948\\u0964 \\u0939\\u093e\\u0932\\u093e\\u0902\\u0915\\u093f, \\u092f\\u0939 \\u0938\\u092d\\u0940 \\u092e\\u093e\\u092e\\u0932\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0909\\u092a\\u092f\\u0941\\u0915\\u094d\\u0924 \\u0928\\u0939\\u0940\\u0902 \\u0939\\u094b \\u0938\\u0915\\u0924\\u093e, \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u091c\\u092c \\u092a\\u0915\\u094d\\u0937\\u094b\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u0936\\u094b\\u0937\\u0923 \\u092f\\u093e \\u0905\\u0927\\u093f\\u0915 \\u0936\\u0915\\u094d\\u0924\\u093f-\\u0938\\u0902\\u0924\\u0941\\u0932\\u0928 \\u0915\\u093e \\u0907\\u0924\\u093f\\u0939\\u093e\\u0938 \\u0939\\u094b\\u0964 \\u0907\\u0938 \\u092a\\u094d\\u0930\\u0915\\u093e\\u0930 \\u0915\\u0947 \\u092e\\u093e\\u092e\\u0932\\u094b\\u0902 \\u092e\\u0947\\u0902, \\u0935\\u093f\\u0935\\u093e\\u0926-\\u0928\\u093f\\u0930\\u094d\\u0927\\u093e\\u0930\\u0923 \\u0915\\u0940 \\u0924\\u0930\\u0939, \\u0935\\u093f\\u091a\\u093e\\u0930 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0905\\u0928\\u094d\\u092f \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0930\\u093e\\u0938\\u094d\\u0924\\u0947 \\u0905\\u0927\\u093f\\u0915 \\u0909\\u092a\\u092f\\u0941\\u0915\\u094d\\u0924 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\r\\n<p>&nbsp;<\\/p>\\r\\n\\r\\n<p>&nbsp;<\\/p>","ar":"<p>\\u0648\\u0633\\u0627\\u0637\\u0629 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u0647\\u064a \\u0639\\u0645\\u0644\\u064a\\u0629 \\u064a\\u0633\\u0627\\u0639\\u062f \\u0641\\u064a\\u0647\\u0627 \\u0637\\u0631\\u0641 \\u062b\\u0627\\u0644\\u062b \\u0645\\u062d\\u0627\\u064a\\u062f\\u060c \\u064a\\u0639\\u0631\\u0641 \\u0628\\u0648\\u0633\\u064a\\u0637\\u060c \\u0627\\u0644\\u0623\\u0632\\u0648\\u0627\\u062c \\u0623\\u0648 \\u0623\\u0641\\u0631\\u0627\\u062f \\u0627\\u0644\\u0639\\u0627\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u064a\\u062e\\u062a\\u0644\\u0641\\u0648\\u0646 \\u0641\\u064a\\u0645\\u0627 \\u0628\\u064a\\u0646\\u0647\\u0645 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0648\\u0627\\u0644\\u062a\\u0641\\u0627\\u0648\\u0636 \\u0648\\u0627\\u0644\\u062a\\u0648\\u0635\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u062a\\u0641\\u0627\\u0642\\u0627\\u062a \\u0628\\u0634\\u0623\\u0646 \\u0645\\u0633\\u0627\\u0626\\u0644 \\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u0639\\u0627\\u0626\\u0644\\u0629. \\u062a\\u0647\\u062f\\u0641 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u0628\\u062f\\u064a\\u0644\\u0629 \\u0644\\u062a\\u0633\\u0648\\u064a\\u0629 \\u0627\\u0644\\u0646\\u0632\\u0627\\u0639\\u0627\\u062a \\u0625\\u0644\\u0649 \\u062a\\u064a\\u0633\\u064a\\u0631 \\u0627\\u0644\\u062d\\u0648\\u0627\\u0631 \\u0627\\u0644\\u0645\\u0641\\u062a\\u0648\\u062d \\u0648\\u0627\\u0644\\u062a\\u0639\\u0627\\u0648\\u0646\\u060c \\u0645\\u0645\\u0627 \\u064a\\u062a\\u064a\\u062d \\u0644\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u062d\\u0644\\u0627\\u064b \\u0645\\u0642\\u0628\\u0648\\u0644\\u0627\\u064b \\u0628\\u0645\\u0648\\u0627\\u0641\\u0642\\u0629 \\u0627\\u0644\\u062c\\u0645\\u064a\\u0639 \\u062f\\u0648\\u0646 \\u0627\\u0644\\u0644\\u062c\\u0648\\u0621 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629.<\\/p>\\r\\n\\r\\n<p>\\u0627\\u0644\\u062c\\u0648\\u0627\\u0646\\u0628 \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0644\\u0648\\u0633\\u0627\\u0637\\u0629 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629:<\\/p>\\r\\n\\r\\n<ol>\\r\\n    <li>\\r\\n        <p>\\u0627\\u0644\\u0642\\u0636\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u0639\\u0627\\u0626\\u0644\\u0629: \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u0634\\u0645\\u0644 \\u0648\\u0633\\u0627\\u0637\\u0629 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0648\\u0627\\u0633\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0646\\u0632\\u0627\\u0639\\u0627\\u062a\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0627\\u0644\\u0637\\u0644\\u0627\\u0642 \\u0648\\u0627\\u0644\\u0627\\u0646\\u0641\\u0635\\u0627\\u0644\\u060c \\u062d\\u0636\\u0627\\u0646\\u0629 \\u0627\\u0644\\u0623\\u0637\\u0641\\u0627\\u0644 \\u0648\\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u0632\\u064a\\u0627\\u0631\\u0629\\u060c \\u062f\\u0639\\u0645 \\u0627\\u0644\\u0623\\u0637\\u0641\\u0627\\u0644\\u060c \\u0627\\u0644\\u062f\\u0639\\u0645 \\u0627\\u0644\\u0632\\u0648\\u062c\\u064a (\\u0627\\u0644\\u0646\\u0641\\u0642\\u0629)\\u060c \\u062a\\u0642\\u0633\\u064a\\u0645 \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a\\u060c \\u0648\\u062e\\u0637\\u0637 \\u0627\\u0644\\u0623\\u0628\\u0648\\u0629 \\u0648\\u0627\\u0644\\u0623\\u0645\\u0648\\u0645\\u0629.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0627\\u0644\\u0648\\u0633\\u064a\\u0637 \\u0627\\u0644\\u0646\\u0632\\u064a\\u0647: \\u0627\\u0644\\u0648\\u0633\\u064a\\u0637 \\u0647\\u0648 \\u0645\\u064a\\u0633\\u0631 \\u0645\\u062d\\u0627\\u064a\\u062f \\u0644\\u0627 \\u064a\\u062a\\u062e\\u0630 \\u062c\\u0627\\u0646\\u0628\\u0627\\u064b \\u0623\\u0648 \\u064a\\u062a\\u062e\\u0630 \\u0642\\u0631\\u0627\\u0631\\u0627\\u062a \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641. \\u062f\\u0648\\u0631\\u0647 \\u0647\\u0648 \\u0645\\u0633\\u0627\\u0639\\u062f\\u0629 \\u0641\\u064a \\u062a\\u062d\\u062f\\u064a\\u062f \\u0627\\u0644\\u0645\\u0635\\u0627\\u0644\\u062d \\u0627\\u0644\\u0645\\u0634\\u062a\\u0631\\u0643\\u0629\\u060c \\u0648\\u062a\\u0639\\u0632\\u064a\\u0632 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644\\u060c \\u0648\\u062a\\u0648\\u062c\\u064a\\u0647 \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u0646\\u062d\\u0648 \\u0627\\u0644\\u062a\\u0648\\u0635\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u062a\\u0641\\u0627\\u0642\\u0627\\u062a.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0637\\u0648\\u0639\\u064a\\u0629: \\u0627\\u0644\\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0641\\u064a \\u0648\\u0633\\u0627\\u0637\\u0629 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u063a\\u0627\\u0644\\u0628\\u0627\\u064b \\u0645\\u0627 \\u062a\\u0643\\u0648\\u0646 \\u0637\\u0648\\u0639\\u064a\\u0629. \\u064a\\u062c\\u0628 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0637\\u0631\\u0641\\u064a\\u0646 \\u0623\\u0646 \\u064a\\u0648\\u0627\\u0641\\u0642\\u0627 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0641\\u064a \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0648\\u0633\\u0627\\u0637\\u0629 \\u0628\\u0645\\u062d\\u0636 \\u0625\\u0631\\u0627\\u062f\\u062a\\u0647\\u0645\\u0627. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643\\u060c \\u0641\\u064a \\u0628\\u0639\\u0636 \\u0627\\u0644\\u0633\\u0644\\u0637\\u0627\\u062a\\u060c \\u0642\\u062f \\u064a\\u0643\\u0648\\u0646 \\u0644\\u0632\\u0627\\u0645\\u064b\\u0627 \\u062a\\u0648\\u062c\\u064a\\u0647 \\u0627\\u0644\\u0648\\u0633\\u0627\\u0637\\u0629 \\u0645\\u0646 \\u0642\\u0628\\u0644 \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0623\\u0648 \\u062a\\u062d\\u062f\\u064a\\u062f\\u0647\\u0627 \\u0642\\u0628\\u0644 \\u0627\\u0644\\u0644\\u062c\\u0648\\u0621 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u062f\\u0639\\u0648\\u0649 \\u0627\\u0644\\u0642\\u0636\\u0627\\u0626\\u064a\\u0629.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0627\\u0644\\u0633\\u0631\\u064a\\u0629: \\u0625\\u0646 \\u0625\\u062c\\u0631\\u0627\\u0621\\u0627\\u062a \\u0627\\u0644\\u0648\\u0633\\u0627\\u0637\\u0629 \\u0633\\u0631\\u064a\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0639\\u0646\\u064a \\u0623\\u0646 \\u0627\\u0644\\u0645\\u0646\\u0627\\u0642\\u0634\\u0627\\u062a \\u0648\\u0627\\u0644\\u062a\\u0641\\u0627\\u0648\\u0636\\u0627\\u062a \\u0648\\u0623\\u064a \\u0645\\u0642\\u062a\\u0631\\u062d\\u0627\\u062a \\u062a\\u0642\\u062f\\u0645 \\u062e\\u0644\\u0627\\u0644 \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0648\\u0633\\u0627\\u0637\\u0629 \\u0644\\u0627 \\u064a\\u0645\\u0643\\u0646 \\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645\\u0647\\u0627 \\u0643\\u062f\\u0644\\u064a\\u0644 \\u0641\\u064a \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0625\\u0630\\u0627 \\u0644\\u0645 \\u062a\\u0624\\u062f\\u064a \\u0627\\u0644\\u0648\\u0633\\u0627\\u0637\\u0629 \\u0625\\u0644\\u0649 \\u062a\\u0633\\u0648\\u064a\\u0629.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0627\\u0644\\u062a\\u0631\\u0643\\u064a\\u0632 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0635\\u0627\\u0644\\u062d \\u0648\\u0627\\u0644\\u0627\\u062d\\u062a\\u064a\\u0627\\u062c\\u0627\\u062a: \\u062a\\u0634\\u062c\\u0639 \\u0627\\u0644\\u0648\\u0633\\u0627\\u0637\\u0629 \\u0627\\u0644\\u0645\\u0634\\u0627\\u0631\\u0643\\u064a\\u0646 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062a\\u0631\\u0643\\u064a\\u0632 \\u0639\\u0644\\u0649 \\u0645\\u0635\\u0627\\u0644\\u062d\\u0647\\u0645 \\u0648\\u0627\\u062d\\u062a\\u064a\\u0627\\u062c\\u0627\\u062a\\u0647\\u0645\\u060c \\u0648\\u0645\\u0635\\u0627\\u0644\\u062d \\u0623\\u0637\\u0641\\u0627\\u0644\\u0647\\u0645\\u060c \\u0628\\u062f\\u0644\\u0627\\u064b \\u0645\\u0646 \\u0627\\u062a\\u062e\\u0627\\u0630 \\u0645\\u0648\\u0627\\u0642\\u0641 \\u0645\\u0639\\u0627\\u062f\\u064a\\u0629. \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u064a\\u0624\\u062f\\u064a \\u0647\\u0630\\u0627 \\u0627\\u0644\\u0646\\u0647\\u062c \\u0625\\u0644\\u0649 \\u062d\\u0644\\u0648\\u0644 \\u0623\\u0643\\u062b\\u0631 \\u062a\\u062e\\u0635\\u064a\\u0635\\u064b\\u0627 \\u0648\\u0642\\u0627\\u0628\\u0644\\u064a\\u0629 \\u0644\\u0644\\u062a\\u0637\\u0628\\u064a\\u0642.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u062a\\u062d\\u0633\\u064a\\u0646 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644: \\u062a\\u0634\\u062c\\u0639 \\u0648\\u0633\\u0627\\u0637\\u0629 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u0639\\u0644\\u0649 \\u062a\\u062d\\u0633\\u064a\\u0646 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0642\\u0644\\u0644 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u062f\\u0627\\u0621 \\u0648\\u0627\\u0644\\u0639\\u062f\\u0627\\u0648\\u0629\\u060c \\u0648\\u0647\\u0648 \\u0623\\u0645\\u0631 \\u0645\\u0647\\u0645 \\u0628\\u0634\\u0643\\u0644 \\u062e\\u0627\\u0635 \\u0641\\u064a \\u0627\\u0644\\u062d\\u0641\\u0627\\u0638 \\u0639\\u0644\\u0649 \\u0639\\u0644\\u0627\\u0642\\u0629 \\u0635\\u062d\\u064a\\u0629 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0648\\u0627\\u0644\\u062f\\u064a\\u0646 \\u0628\\u0639\\u062f \\u0627\\u0644\\u0637\\u0644\\u0627\\u0642 \\u0623\\u0648 \\u0627\\u0644\\u0627\\u0646\\u0641\\u0635\\u0627\\u0644.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0643\\u0641\\u0627\\u0621\\u0629 \\u0648\\u0641\\u0639\\u0627\\u0644\\u064a\\u0629 \\u0645\\u0646 \\u062d\\u064a\\u062b \\u0627\\u0644\\u062a\\u0643\\u0644\\u0641\\u0629: \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u0643\\u0648\\u0646 \\u0627\\u0644\\u0648\\u0633\\u0627\\u0637\\u0629 \\u0628\\u062f\\u064a\\u0644\\u0627\\u064b \\u0623\\u0633\\u0631\\u0639 \\u0648\\u0623\\u0643\\u062b\\u0631 \\u0641\\u0639\\u0627\\u0644\\u064a\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0625\\u062c\\u0631\\u0627\\u0621\\u0627\\u062a \\u0627\\u0644\\u0642\\u0636\\u0627\\u0626\\u064a\\u0629 \\u0627\\u0644\\u062a\\u0642\\u0644\\u064a\\u062f\\u064a\\u0629. \\u0625\\u0646\\u0647\\u0627 \\u062a\\u0633\\u0645\\u062d \\u0644\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u0628\\u0627\\u0644\\u062a\\u062d\\u0643\\u0645 \\u0641\\u064a \\u0627\\u0644\\u0646\\u062a\\u064a\\u062c\\u0629 \\u0628\\u0634\\u0643\\u0644 \\u0623\\u0643\\u0628\\u0631 \\u0648\\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u0633\\u0627\\u0639\\u062f \\u0641\\u064a \\u0645\\u0646\\u0639 \\u0627\\u0644\\u062f\\u0639\\u0627\\u0648\\u0649 \\u0627\\u0644\\u0642\\u0636\\u0627\\u0626\\u064a\\u0629 \\u0627\\u0644\\u0637\\u0648\\u064a\\u0644\\u0629 \\u0648\\u0627\\u0644\\u0645\\u0643\\u0644\\u0641\\u0629.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0627\\u0633\\u062a\\u0639\\u0631\\u0627\\u0636 \\u0642\\u0627\\u0646\\u0648\\u0646\\u064a: \\u0628\\u0639\\u062f \\u0627\\u0644\\u062a\\u0648\\u0635\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u062a\\u0641\\u0627\\u0642\\u064a\\u0627\\u062a \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0627\\u0644\\u0648\\u0633\\u0627\\u0637\\u0629\\u060c \\u0642\\u062f \\u064a\\u062e\\u062a\\u0627\\u0631 \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0629 \\u0627\\u0644\\u0627\\u062a\\u0641\\u0627\\u0642\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0645\\u062a \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0627\\u0644\\u0648\\u0633\\u0627\\u0637\\u0629 \\u0645\\u0646 \\u0642\\u0628\\u0644 \\u0645\\u062d\\u0627\\u0645\\u064a\\u0647\\u0645\\u0627 \\u0627\\u0644\\u062e\\u0627\\u0635 \\u0642\\u0628\\u0644 \\u0625\\u062a\\u0645\\u0627\\u0645\\u0647\\u0627 \\u0648\\u062a\\u0642\\u062f\\u064a\\u0645\\u0647\\u0627 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629 \\u0644\\u0644\\u0645\\u0648\\u0627\\u0641\\u0642\\u0629 \\u0639\\u0644\\u064a\\u0647\\u0627.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0648\\u0627\\u0644\\u062a\\u0646\\u0641\\u064a\\u0630: \\u0628\\u0645\\u062c\\u0631\\u062f \\u0623\\u0646 \\u062a\\u062d\\u0635\\u0644 \\u0627\\u0644\\u0627\\u062a\\u0641\\u0627\\u0642\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0645\\u062a \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0627\\u0644\\u0648\\u0633\\u0627\\u0637\\u0629 \\u0639\\u0644\\u0649 \\u0645\\u0648\\u0627\\u0641\\u0642\\u0629 \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629\\u060c \\u062a\\u0635\\u0628\\u062d \\u0639\\u0642\\u062f\\u0627\\u064b \\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0627\\u064b \\u064a\\u0644\\u0632\\u0645 \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641\\u060c \\u0648\\u064a\\u062c\\u0628 \\u0639\\u0644\\u064a\\u0647\\u0645 \\u0627\\u0644\\u0627\\u0644\\u062a\\u0632\\u0627\\u0645 \\u0628\\u0634\\u0631\\u0648\\u0637\\u0647\\u0627. \\u0625\\u0630\\u0627 \\u0641\\u0634\\u0644 \\u0623\\u062d\\u062f \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641 \\u0641\\u064a \\u0627\\u0644\\u0627\\u0645\\u062a\\u062b\\u0627\\u0644 \\u0644\\u0644\\u0627\\u062a\\u0641\\u0627\\u0642\\u064a\\u0629\\u060c \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u0637\\u0631\\u0641 \\u0627\\u0644\\u0622\\u062e\\u0631 \\u0637\\u0644\\u0628 \\u062a\\u0646\\u0641\\u064a\\u0630\\u0647\\u0627 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0627\\u0644\\u0645\\u062d\\u0643\\u0645\\u0629.<\\/p>\\r\\n    <\\/li>\\r\\n<\\/ol>\\r\\n\\r\\n<p>\\u062a\\u0639\\u062a\\u0628\\u0631 \\u0648\\u0633\\u0627\\u0637\\u0629 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629 \\u0623\\u062f\\u0627\\u0629 \\u0642\\u064a\\u0645\\u0629 \\u0644\\u062a\\u0633\\u0648\\u064a\\u0629 \\u0627\\u0644\\u0646\\u0632\\u0627\\u0639\\u0627\\u062a \\u0628\\u0634\\u0643\\u0644 \\u0648\\u062f\\u064a\\u060c \\u062e\\u0627\\u0635\\u0629 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0633\\u0627\\u0626\\u0644 \\u0627\\u0644\\u0639\\u0627\\u0626\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u062a\\u062d\\u0645\\u0644 \\u0627\\u0644\\u0643\\u062b\\u064a\\u0631 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0648\\u0627\\u0637\\u0641. \\u0625\\u0646\\u0647\\u0627 \\u062a\\u0645\\u0643\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0634\\u0627\\u0631\\u0643\\u0629 \\u0627\\u0644\\u0641\\u0639\\u0627\\u0644\\u0629 \\u0641\\u064a \\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u062a\\u062e\\u0627\\u0630 \\u0627\\u0644\\u0642\\u0631\\u0627\\u0631\\u060c \\u0648\\u062a\\u0639\\u0632\\u0632 \\u0627\\u0644\\u062c\\u0648 \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u062a\\u0639\\u0627\\u0648\\u0646\\u0627\\u064b\\u060c \\u0648\\u062a\\u0633\\u0627\\u0639\\u062f \\u0641\\u064a \\u0627\\u0644\\u062d\\u0641\\u0627\\u0638 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0639\\u0644\\u0627\\u0642\\u0627\\u062a \\u0628\\u064a\\u0646\\u0645\\u0627 \\u062a\\u0639\\u0627\\u0644\\u062c \\u0627\\u0644\\u0645\\u0633\\u0627\\u0626\\u0644 \\u0627\\u0644\\u0647\\u0627\\u0645\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u0623\\u0633\\u0631\\u0629. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643\\u060c \\u0642\\u062f \\u0644\\u0627 \\u062a\\u0643\\u0648\\u0646 \\u0645\\u0646\\u0627\\u0633\\u0628\\u0629 \\u0644\\u062c\\u0645\\u064a\\u0639 \\u0627\\u0644\\u062d\\u0627\\u0644\\u0627\\u062a\\u060c \\u062e\\u0627\\u0635\\u0629 \\u0639\\u0646\\u062f\\u0645\\u0627 \\u062a\\u0643\\u0648\\u0646 \\u0647\\u0646\\u0627\\u0643 \\u062a\\u0627\\u0631\\u064a\\u062e \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0646\\u0641 \\u0623\\u0648 \\u0627\\u0644\\u062a\\u0641\\u0627\\u0648\\u062a \\u0627\\u0644\\u0643\\u0628\\u064a\\u0631 \\u0641\\u064a \\u0627\\u0644\\u0642\\u0648\\u0629 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0623\\u0637\\u0631\\u0627\\u0641. \\u0641\\u064a \\u0645\\u062b\\u0644 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062d\\u0627\\u0644\\u0627\\u062a\\u060c \\u0642\\u062f \\u064a\\u0643\\u0648\\u0646 \\u0645\\u0646 \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0627\\u0644\\u0644\\u062c\\u0648\\u0621 \\u0625\\u0644\\u0649 \\u0648\\u0633\\u0627\\u0626\\u0644 \\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0623\\u062e\\u0631\\u0649\\u060c \\u0645\\u062b\\u0644 \\u0627\\u0644\\u062f\\u0639\\u0648\\u0649 \\u0627\\u0644\\u0642\\u0636\\u0627\\u0626\\u064a\\u0629.<\\/p>\\r\\n\\r\\n<p>&nbsp;<\\/p>\\r\\n\\r\\n<p>&nbsp;<\\/p>"}',
                'icon' => '/images/therapist_main_categories/64cb8a1261c81.png',
                'id' => 4,
                'image' => '/images/therapist_main_categories/64cb8a1261536.png',
                'is_active' => 1,
                'is_featured' => 1,
                'name' => '{"en":"Family Therapy Mediation","hi":"\\u092a\\u093e\\u0930\\u093f\\u0935\\u093e\\u0930\\u093f\\u0915 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u092e\\u0927\\u094d\\u092f\\u0938\\u094d\\u0925\\u0924\\u093e","ar":"\\u0648\\u0633\\u0627\\u0637\\u0629 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u0623\\u0633\\u0631\\u0629"}',
                'slug' => 'family-therapy-mediation-4',
                'updated_at' => '2023-10-10 18:33:00',
            ),
            4 => 
            array (
                'created_at' => '2023-08-03 15:42:04',
                'deleted_at' => NULL,
            'description' => '{"en":"<p>Education therapy refers to the body of legal principles and regulations that govern the field of education. These therapys are designed to ensure the rights, responsibilities, and obligations of students, educators, parents, and educational institutions are protected and upheld. Education therapy covers a wide range of issues, including but not limited to:<\\/p>\\r\\n\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p>Access to Education: Ensuring that all individuals have equal access to educational opportunities, regardless of their race, ethnicity, gender, disability, or socio-economic status.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Special Education: Addressing the rights and accommodations for students with disabilities to receive appropriate education and support services under the Individuals with Disabilities Education Act (IDEA) in the United States.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Student Rights: Protecting the constitutional rights of students, such as freedom of speech, privacy rights, and protection against discrimination and harassment.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>School Discipline: Establishing the guidelines and procedures for disciplinary actions and suspension\\/expulsion of students, while ensuring due process.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>School Safety: Implementing measures to maintain a safe and conducive learning environment for students and staff.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Curriculum and Standards: Setting educational standards and guidelines for schools and ensuring the delivery of a well-rounded and comprehensive curriculum.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>School Funding: Addressing issues related to public funding for educational institutions and the equitable distribution of resources.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Teacher and Staff Rights: Defining the rights and responsibilities of educators and staff members, including matters related to contracts, tenure, and due process.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>School Governance: Outlining the structure and responsibilities of school boards, administrators, and other decision-making bodies in educational institutions.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Higher Education: Covering legal matters related to colleges, universities, and other post-secondary institutions, including admissions, financial aid, and academic integrity.<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>Privacy and Student Records: Safeguarding the confidentiality of student records and protecting personal information under therapys like the Family Educational Rights and Privacy Act (FERPA).<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n\\r\\n<p>These are just some of the key areas that education therapy encompasses. Education therapys can vary significantly between countries and even within different regions of a country, so it&#39;s essential to be familiar with the specific therapys and regulations applicable in a particular jurisdiction. As with any legal matters, it&#39;s advisable to seek the advice of legal professionals specialized in education therapy when dealing with educational issues or disputes.<\\/p>","hi":"<p>\\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0909\\u0928 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u0938\\u093f\\u0926\\u094d\\u0927\\u093e\\u0902\\u0924\\u094b\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u093e \\u0938\\u092e\\u0942\\u0939 \\u0939\\u0948 \\u091c\\u094b \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930 \\u0915\\u094b \\u0928\\u093f\\u092f\\u0902\\u0924\\u094d\\u0930\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964 \\u092f\\u0947 \\u0915\\u093e\\u0928\\u0942\\u0928 \\u091b\\u093e\\u0924\\u094d\\u0930\\u094b\\u0902, \\u0936\\u093f\\u0915\\u094d\\u0937\\u0915\\u094b\\u0902, \\u092e\\u093e\\u0924\\u093e-\\u092a\\u093f\\u0924\\u093e \\u0914\\u0930 \\u0936\\u0948\\u0915\\u094d\\u0937\\u093f\\u0915 \\u0938\\u0902\\u0938\\u094d\\u0925\\u093e\\u0913\\u0902 \\u0915\\u0947 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930, \\u091c\\u093f\\u092e\\u094d\\u092e\\u0947\\u0926\\u093e\\u0930\\u093f\\u092f\\u093e\\u0901 \\u0914\\u0930 \\u0915\\u0930\\u094d\\u0924\\u0935\\u094d\\u092f\\u094b\\u0902 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0914\\u0930 \\u0938\\u0902\\u0930\\u0915\\u094d\\u0937\\u0923 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0921\\u093f\\u091c\\u093c\\u093e\\u0907\\u0928 \\u0915\\u093f\\u090f \\u0917\\u090f \\u0939\\u0948\\u0902\\u0964 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u092e\\u0941\\u0926\\u094d\\u0926\\u094b\\u0902 \\u0915\\u094b \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0915\\u0930\\u0924\\u093e \\u0939\\u0948, \\u091c\\u093f\\u0928\\u092e\\u0947\\u0902 \\u0928\\u093f\\u092e\\u094d\\u0928\\u0932\\u093f\\u0916\\u093f\\u0924 \\u0938\\u0947 \\u0915\\u092e \\u0928\\u0939\\u0940\\u0902 \\u0939\\u0948:<\\/p>\\r\\n\\r\\n<ol>\\r\\n\\t<li>\\r\\n\\t<p>\\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0915\\u093e \\u092a\\u0939\\u0941\\u0902\\u091a: \\u092f\\u0939 \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u093e \\u0939\\u0948 \\u0915\\u093f \\u0938\\u092d\\u0940 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0909\\u0928\\u0915\\u0947 \\u091c\\u093e\\u0924\\u093f, \\u0928\\u0938\\u094d\\u0932, \\u0932\\u093f\\u0902\\u0917, \\u0935\\u093f\\u0915\\u0932\\u093e\\u0902\\u0917\\u0924\\u093e \\u092f\\u093e \\u0938\\u093e\\u092e\\u093e\\u091c\\u093f\\u0915 \\u0906\\u0930\\u094d\\u0925\\u093f\\u0915 \\u0938\\u094d\\u0925\\u093f\\u0924\\u093f \\u0915\\u0947 \\u0906\\u0927\\u093e\\u0930 \\u092a\\u0930 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0915\\u0947 \\u0905\\u0935\\u0938\\u0930\\u094b\\u0902 \\u0915\\u093e \\u0938\\u092e\\u093e\\u0928 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930 \\u0939\\u0948\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0935\\u093f\\u0936\\u0947\\u0937 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e: \\u0938\\u0902\\u0918\\u091f\\u0928 \\u0938\\u0947 \\u0938\\u092e\\u094d\\u092c\\u0902\\u0927\\u093f\\u0924 \\u091b\\u093e\\u0924\\u094d\\u0930\\u094b\\u0902 \\u0915\\u0947 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0914\\u0930 \\u0938\\u0941\\u0935\\u093f\\u0927\\u093e\\u0913\\u0902 \\u0915\\u093e \\u0938\\u092e\\u093e\\u0927\\u093e\\u0928 \\u0915\\u0930\\u0928\\u093e \\u091c\\u094b \\u0938\\u0902\\u0918\\u091f\\u0928 \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0915\\u093e\\u0928\\u0942\\u0928 (IDEA) \\u0915\\u0947 \\u0924\\u0939\\u0924 \\u0938\\u0902\\u0918\\u091f\\u0928 \\u0915\\u0947 \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0914\\u0930 \\u0938\\u092e\\u0930\\u094d\\u0925\\u0928 \\u0938\\u0947\\u0935\\u093e\\u090f\\u0902 \\u092a\\u094d\\u0930\\u093e\\u092a\\u094d\\u0924 \\u0915\\u0930\\u0928\\u0947 \\u0915\\u093e \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930 \\u0930\\u0916\\u0924\\u0947 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u091b\\u093e\\u0924\\u094d\\u0930 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930: \\u091b\\u093e\\u0924\\u094d\\u0930\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u0902\\u0935\\u0948\\u0927\\u093e\\u0928\\u093f\\u0915 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0928\\u093e, \\u091c\\u0948\\u0938\\u0947 \\u0915\\u093f \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f \\u0915\\u0940 \\u0906\\u091c\\u093c\\u093e\\u0926\\u0940 \\u092d\\u093e\\u0937\\u0923, \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0915\\u0947 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930 \\u0914\\u0930 \\u092d\\u0947\\u0926\\u092d\\u093e\\u0935 \\u0914\\u0930 \\u0938\\u0902\\u0915\\u091f \\u0915\\u0947 \\u0916\\u093f\\u0932\\u093e\\u092b \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0935\\u093f\\u0926\\u094d\\u092f\\u093e\\u0932\\u092f \\u0905\\u0928\\u0941\\u0936\\u093e\\u0938\\u0928: \\u091b\\u093e\\u0924\\u094d\\u0930\\u094b\\u0902 \\u0915\\u0947 \\u0936\\u093e\\u0938\\u094d\\u0924\\u094d\\u0930\\u0940\\u092f \\u0915\\u093e\\u0930\\u094d\\u0930\\u0935\\u093e\\u0908 \\u0914\\u0930 \\u0928\\u093f\\u0932\\u0902\\u092c\\u0928 \\/ \\u0928\\u093f\\u0937\\u094d\\u0915\\u093e\\u0938\\u0923 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0928\\u093f\\u0930\\u094d\\u0926\\u0947\\u0936\\u093f\\u0915\\u093e\\u090f\\u0902 \\u0914\\u0930 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e\\u090f\\u0901 \\u0938\\u094d\\u0925\\u093e\\u092a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u093e, \\u0938\\u0941\\u0928\\u093f\\u0936\\u094d\\u091a\\u093f\\u0924 \\u0915\\u0930\\u0924\\u0947 \\u0939\\u0941\\u090f \\u0915\\u093f \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0939\\u094b\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0935\\u093f\\u0926\\u094d\\u092f\\u093e\\u0932\\u092f \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e: \\u091b\\u093e\\u0924\\u094d\\u0930\\u094b\\u0902 \\u0914\\u0930 \\u0915\\u0930\\u094d\\u092e\\u091a\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u090f\\u0915 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093f\\u0924 \\u0914\\u0930 \\u0909\\u092a\\u092f\\u0941\\u0915\\u094d\\u0924 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0935\\u093e\\u0924\\u093e\\u0935\\u0930\\u0923 \\u092c\\u0928\\u093e\\u090f \\u0930\\u0916\\u0928\\u0947 \\u0915\\u0947 \\u0909\\u092a\\u093e\\u092f\\u094b\\u0902 \\u0915\\u094b \\u0932\\u093e\\u0917\\u0942 \\u0915\\u0930\\u0928\\u093e\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u092a\\u093e\\u0920\\u094d\\u092f\\u0915\\u094d\\u0930\\u092e \\u0914\\u0930 \\u092e\\u093e\\u0928\\u0915: \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u092e\\u093e\\u0928\\u0915 \\u0914\\u0930 \\u0926\\u093f\\u0936\\u093e\\u0928\\u093f\\u0930\\u094d\\u0926\\u0947\\u0936\\u094b\\u0902 \\u0915\\u094b \\u0938\\u094d\\u0925\\u093e\\u092a\\u093f\\u0924 \\u0915\\u0930\\u0928\\u093e \\u0914\\u0930 \\u0935\\u093f\\u0926\\u094d\\u092f\\u093e\\u0932\\u092f\\u094b\\u0902 \\u0915\\u094b \\u090f\\u0915 \\u0938\\u0902\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0914\\u0930 \\u0935\\u094d\\u092f\\u093e\\u092a\\u0915 \\u092a\\u093e\\u0920\\u094d\\u092f\\u0915\\u094d\\u0930\\u092e \\u0915\\u0940 \\u0935\\u093f\\u092a\\u0923\\u0928 \\u0926\\u0947\\u0928\\u0947 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0928\\u093e\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0935\\u093f\\u0926\\u094d\\u092f\\u093e\\u0932\\u092f \\u0935\\u093f\\u0924\\u094d\\u0924: \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0938\\u0902\\u0938\\u094d\\u0925\\u093e\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0932\\u093f\\u090f \\u0938\\u093e\\u0930\\u094d\\u0935\\u091c\\u0928\\u093f\\u0915 \\u0935\\u093f\\u0924\\u094d\\u0924 \\u092a\\u0930 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u092e\\u0941\\u0926\\u094d\\u0926\\u094b\\u0902 \\u0915\\u093e \\u0938\\u092e\\u093e\\u0927\\u093e\\u0928 \\u0915\\u0930\\u0928\\u093e \\u0914\\u0930 \\u0938\\u0902\\u0938\\u093e\\u0927\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0928\\u094d\\u092f\\u093e\\u092f\\u0938\\u092e\\u094d\\u092e\\u0924 \\u0935\\u093f\\u0924\\u0930\\u0923 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0928\\u093e\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0936\\u093f\\u0915\\u094d\\u0937\\u0915 \\u0914\\u0930 \\u0915\\u0930\\u094d\\u092e\\u091a\\u093e\\u0930\\u0940 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930: \\u0936\\u093f\\u0915\\u094d\\u0937\\u0915\\u094b\\u0902 \\u0914\\u0930 \\u0915\\u0930\\u094d\\u092e\\u091a\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930\\u094b\\u0902 \\u0914\\u0930 \\u091c\\u093f\\u092e\\u094d\\u092e\\u0947\\u0926\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0940 \\u092a\\u0930\\u093f\\u092d\\u093e\\u0937\\u093e \\u0915\\u0930\\u0928\\u093e, \\u091c\\u093f\\u0938\\u092e\\u0947\\u0902 \\u0905\\u0928\\u0941\\u092c\\u0902\\u0927\\u094b\\u0902, \\u0938\\u094d\\u0925\\u093f\\u0924\\u093f \\u0914\\u0930 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u092a\\u094d\\u0930\\u0915\\u094d\\u0930\\u093f\\u092f\\u093e \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u092e\\u093e\\u092e\\u0932\\u0947 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0935\\u093f\\u0926\\u094d\\u092f\\u093e\\u0932\\u092f \\u0936\\u093e\\u0938\\u0928: \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0938\\u0902\\u0938\\u094d\\u0925\\u093e\\u0928\\u094b\\u0902 \\u092e\\u0947\\u0902 \\u0935\\u093f\\u0926\\u094d\\u092f\\u093e\\u0932\\u092f \\u092a\\u0930\\u093f\\u0937\\u0926\\u094b\\u0902, \\u092a\\u094d\\u0930\\u0936\\u093e\\u0938\\u0915\\u094b\\u0902 \\u0914\\u0930 \\u0905\\u0928\\u094d\\u092f \\u0928\\u093f\\u0930\\u094d\\u0923\\u092f \\u0932\\u0947\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u0928\\u093f\\u0915\\u093e\\u092f\\u094b\\u0902 \\u0915\\u0940 \\u0938\\u0902\\u0930\\u091a\\u0928\\u093e \\u0914\\u0930 \\u091c\\u093f\\u092e\\u094d\\u092e\\u0947\\u0926\\u093e\\u0930\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0940 \\u0930\\u0942\\u092a\\u0930\\u0947\\u0916\\u093e \\u0915\\u0930\\u0928\\u093e\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0909\\u091a\\u094d\\u091a \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e: \\u0915\\u0949\\u0932\\u0947\\u091c\\u094b\\u0902, \\u0935\\u093f\\u0936\\u094d\\u0935\\u0935\\u093f\\u0926\\u094d\\u092f\\u093e\\u0932\\u092f\\u094b\\u0902 \\u0914\\u0930 \\u0905\\u0928\\u094d\\u092f \\u092a\\u094b\\u0938\\u094d\\u091f-\\u0938\\u0947\\u0915\\u0947\\u0902\\u0921\\u0930\\u0940 \\u0938\\u0902\\u0938\\u094d\\u0925\\u093e\\u0928\\u094b\\u0902 \\u0938\\u0947 \\u0938\\u0902\\u092c\\u0902\\u0927\\u093f\\u0924 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u092e\\u0941\\u0926\\u094d\\u0926\\u094b\\u0902 \\u0915\\u094b \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0915\\u0930\\u0928\\u093e, \\u091c\\u093f\\u0938\\u092e\\u0947\\u0902 \\u092a\\u094d\\u0930\\u0935\\u0947\\u0936, \\u0935\\u093f\\u0924\\u094d\\u0924\\u0940\\u092f \\u0938\\u0939\\u093e\\u092f\\u0924\\u093e \\u0914\\u0930 \\u0936\\u0948\\u0915\\u094d\\u0937\\u093f\\u0915 \\u0905\\u0935\\u0938\\u0930\\u094b\\u0902 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0902\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n\\t<li>\\r\\n\\t<p>\\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0914\\u0930 \\u091b\\u093e\\u0924\\u094d\\u0930 \\u0930\\u093f\\u0915\\u0949\\u0930\\u094d\\u0921: \\u091b\\u093e\\u0924\\u094d\\u0930 \\u0930\\u093f\\u0915\\u0949\\u0930\\u094d\\u0921 \\u0915\\u0940 \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0928\\u093e \\u0914\\u0930 \\u092a\\u0930\\u093f\\u0935\\u093e\\u0930\\u093f\\u0915 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e\\u0924\\u094d\\u092e\\u0915 \\u0905\\u0927\\u093f\\u0915\\u093e\\u0930 \\u0914\\u0930 \\u0917\\u094b\\u092a\\u0928\\u0940\\u092f\\u0924\\u093e \\u0915\\u093e\\u0928\\u0942\\u0928 (FERPA) \\u091c\\u0948\\u0938\\u0947 \\u0915\\u093e\\u0928\\u0942\\u0928\\u094b\\u0902 \\u0915\\u0947 \\u0924\\u0939\\u0924 \\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f\\u0917\\u0924 \\u091c\\u093e\\u0928\\u0915\\u093e\\u0930\\u0940 \\u0915\\u0940 \\u0938\\u0941\\u0930\\u0915\\u094d\\u0937\\u093e \\u0915\\u0930\\u0928\\u093e\\u0964<\\/p>\\r\\n\\t<\\/li>\\r\\n<\\/ol>\\r\\n\\r\\n<p>\\u092f\\u0947 \\u0915\\u0941\\u091b \\u0915\\u0941\\u0902\\u091c\\u0940\\u092f \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930 \\u0939\\u0948\\u0902 \\u091c\\u093f\\u0928\\u092e\\u0947\\u0902 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0936\\u093e\\u092e\\u093f\\u0932 \\u0939\\u0948\\u0964 \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0915\\u093e\\u0928\\u0942\\u0928 \\u0926\\u0947\\u0936\\u094b\\u0902 \\u0914\\u0930 \\u090f\\u0915 \\u0939\\u0940 \\u0926\\u0947\\u0936 \\u0915\\u0947 \\u0935\\u093f\\u092d\\u093f\\u0928\\u094d\\u0928 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930\\u094b\\u0902 \\u0915\\u0947 \\u092c\\u0940\\u091a \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0930\\u0942\\u092a \\u0938\\u0947 \\u092d\\u093f\\u0928\\u094d\\u0928 \\u0939\\u094b \\u0938\\u0915\\u0924\\u0947 \\u0939\\u0948\\u0902, \\u0907\\u0938\\u0932\\u093f\\u090f \\u090f\\u0915 \\u0935\\u093f\\u0936\\u0947\\u0937 \\u0915\\u094d\\u0937\\u0947\\u0924\\u094d\\u0930 \\u092e\\u0947\\u0902 \\u0932\\u093e\\u0917\\u0942 \\u0939\\u094b\\u0928\\u0947 \\u0935\\u093e\\u0932\\u0947 \\u0935\\u093f\\u0936\\u093f\\u0937\\u094d\\u091f \\u0915\\u093e\\u0928\\u0942\\u0928\\u094b\\u0902 \\u0914\\u0930 \\u0935\\u093f\\u0927\\u093f\\u092f\\u094b\\u0902 \\u0915\\u0947 \\u092c\\u093e\\u0930\\u0947 \\u092e\\u0947\\u0902 \\u092a\\u0930\\u093f\\u091a\\u093f\\u0924 \\u0939\\u094b\\u0928\\u093e \\u092e\\u0939\\u0924\\u094d\\u0935\\u092a\\u0942\\u0930\\u094d\\u0923 \\u0939\\u0948\\u0964 \\u0915\\u093f\\u0938\\u0940 \\u092d\\u0940 \\u0915\\u093e\\u0928\\u0942\\u0928\\u0940 \\u092e\\u093e\\u092e\\u0932\\u094b\\u0902 \\u0915\\u0947 \\u0938\\u093e\\u0925, \\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0915\\u093e\\u0928\\u0942\\u0928 \\u092e\\u0947\\u0902 \\u0935\\u093f\\u0936\\u0947\\u0937\\u091c\\u094d\\u091e\\u093f\\u0924 \\u0935\\u093f\\u0927\\u093f\\u091c\\u094d\\u091e\\u094b\\u0902 \\u0915\\u0940 \\u0938\\u0932\\u093e\\u0939 \\u0932\\u0947\\u0928\\u093e \\u0938\\u0932\\u093e\\u0939\\u0915\\u093e\\u0930 \\u0939\\u0948\\u0964<\\/p>","ar":"<p>\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u064a\\u0634\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0628\\u0627\\u062f\\u0626 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0644\\u0648\\u0627\\u0626\\u062d \\u0627\\u0644\\u062a\\u064a \\u062a\\u062d\\u0643\\u0645 \\u0645\\u064a\\u062f\\u0627\\u0646 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645. \\u062a\\u0645 \\u062a\\u0635\\u0645\\u064a\\u0645 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0644\\u0636\\u0645\\u0627\\u0646 \\u062d\\u0645\\u0627\\u064a\\u0629 \\u0648\\u0635\\u0648\\u0646 \\u062d\\u0642\\u0648\\u0642 \\u0648\\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0627\\u062a \\u0648\\u0627\\u0644\\u062a\\u0632\\u0627\\u0645\\u0627\\u062a \\u0627\\u0644\\u0637\\u0644\\u0627\\u0628 \\u0648\\u0627\\u0644\\u0645\\u0639\\u0644\\u0645\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0623\\u0647\\u0644 \\u0648\\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u0627\\u062a \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645\\u064a\\u0629. \\u064a\\u063a\\u0637\\u064a \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0648\\u0627\\u0633\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0642\\u0636\\u0627\\u064a\\u0627\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0648\\u0644\\u0643\\u0646 \\u0644\\u0627 \\u064a\\u0642\\u062a\\u0635\\u0631 \\u0639\\u0644\\u0649:<\\/p>\\r\\n\\r\\n<ol>\\r\\n    <li>\\r\\n        <p>\\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645: \\u0636\\u0645\\u0627\\u0646 \\u0623\\u0646 \\u0644\\u062f\\u0649 \\u062c\\u0645\\u064a\\u0639 \\u0627\\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0646\\u0641\\u0633 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0641\\u0631\\u0635 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645\\u064a\\u0629\\u060c \\u0628\\u063a\\u0636 \\u0627\\u0644\\u0646\\u0638\\u0631 \\u0639\\u0646 \\u0639\\u0631\\u0642\\u0647\\u0645 \\u0623\\u0648 \\u0623\\u0635\\u0644\\u0647\\u0645 \\u0627\\u0644\\u0627\\u062c\\u062a\\u0645\\u0627\\u0639\\u064a \\u0623\\u0648 \\u062c\\u0646\\u0633\\u0647\\u0645 \\u0623\\u0648 \\u0625\\u0639\\u0627\\u0642\\u062a\\u0647\\u0645.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0627\\u0644\\u062e\\u0627\\u0635: \\u0627\\u0644\\u062a\\u0639\\u0627\\u0645\\u0644 \\u0645\\u0639 \\u062d\\u0642\\u0648\\u0642 \\u0648\\u062a\\u0633\\u0647\\u064a\\u0644\\u0627\\u062a \\u0627\\u0644\\u0637\\u0644\\u0627\\u0628 \\u0630\\u0648\\u064a \\u0627\\u0644\\u0627\\u062d\\u062a\\u064a\\u0627\\u062c\\u0627\\u062a \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0644\\u062a\\u0644\\u0642\\u064a \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0627\\u0644 \\u0645\\u0646\\u0627\\u0633\\u0628 \\u0648\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u062f\\u0639\\u0645 \\u0628\\u0645\\u0648\\u062c\\u0628 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0644\\u0644\\u0623\\u0641\\u0631\\u0627\\u062f \\u0630\\u0648\\u064a \\u0627\\u0644\\u0627\\u062d\\u062a\\u064a\\u0627\\u062c\\u0627\\u062a \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 (IDEA) \\u0641\\u064a \\u0627\\u0644\\u0648\\u0644\\u0627\\u064a\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u062d\\u062f\\u0629.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u0637\\u0644\\u0627\\u0628: \\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u062f\\u0633\\u062a\\u0648\\u0631\\u064a\\u0629 \\u0644\\u0644\\u0637\\u0644\\u0627\\u0628\\u060c \\u0645\\u062b\\u0644 \\u062d\\u0631\\u064a\\u0629 \\u0627\\u0644\\u062a\\u0639\\u0628\\u064a\\u0631 \\u0648\\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u062a\\u0645\\u064a\\u064a\\u0632 \\u0648\\u0627\\u0644\\u062a\\u062d\\u0631\\u0634.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0627\\u0646\\u0636\\u0628\\u0627\\u0637 \\u0627\\u0644\\u0645\\u062f\\u0631\\u0633\\u0629: \\u0648\\u0636\\u0639 \\u0627\\u0644\\u0625\\u0631\\u0634\\u0627\\u062f\\u0627\\u062a \\u0648\\u0627\\u0644\\u0625\\u062c\\u0631\\u0627\\u0621\\u0627\\u062a \\u0644\\u0644\\u0625\\u062c\\u0631\\u0627\\u0621\\u0627\\u062a \\u0627\\u0644\\u062a\\u0623\\u062f\\u064a\\u0628\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0625\\u064a\\u0642\\u0627\\u0641\\/\\u0627\\u0644\\u0637\\u0631\\u062f \\u0644\\u0644\\u0637\\u0644\\u0627\\u0628\\u060c \\u0645\\u0639 \\u0636\\u0645\\u0627\\u0646 \\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0646\\u0638\\u0627\\u0645\\u064a\\u0629.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0633\\u0644\\u0627\\u0645\\u0629 \\u0627\\u0644\\u0645\\u062f\\u0631\\u0633\\u0629: \\u062a\\u0646\\u0641\\u064a\\u0630 \\u0627\\u0644\\u062a\\u062f\\u0627\\u0628\\u064a\\u0631 \\u0644\\u0644\\u062d\\u0641\\u0627\\u0638 \\u0639\\u0644\\u0649 \\u0628\\u064a\\u0626\\u0629 \\u062a\\u0639\\u0644\\u0645 \\u0622\\u0645\\u0646\\u0629 \\u0648\\u0645\\u0648\\u0627\\u062a\\u064a\\u0629 \\u0644\\u0644\\u0637\\u0644\\u0627\\u0628 \\u0648\\u0627\\u0644\\u0645\\u0648\\u0638\\u0641\\u064a\\u0646.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0627\\u0644\\u0645\\u0646\\u0647\\u0627\\u062c \\u0648\\u0627\\u0644\\u0645\\u0639\\u0627\\u064a\\u064a\\u0631: \\u062a\\u062d\\u062f\\u064a\\u062f \\u0627\\u0644\\u0645\\u0639\\u0627\\u064a\\u064a\\u0631 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0625\\u0631\\u0634\\u0627\\u062f\\u0627\\u062a \\u0644\\u0644\\u0645\\u062f\\u0627\\u0631\\u0633 \\u0648\\u0636\\u0645\\u0627\\u0646 \\u062a\\u0642\\u062f\\u064a\\u0645 \\u0645\\u0646\\u0647\\u0627\\u062c \\u0634\\u0627\\u0645\\u0644 \\u0648\\u0645\\u062a\\u0648\\u0627\\u0632\\u0646.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u062a\\u0645\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0645\\u062f\\u0631\\u0633\\u0629: \\u0627\\u0644\\u062a\\u0639\\u0627\\u0645\\u0644 \\u0645\\u0639 \\u0627\\u0644\\u0642\\u0636\\u0627\\u064a\\u0627 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u062a\\u0645\\u0648\\u064a\\u0644 \\u0627\\u0644\\u0639\\u0627\\u0645 \\u0644\\u0644\\u0645\\u0624\\u0633\\u0633\\u0627\\u062a \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062a\\u0648\\u0632\\u064a\\u0639 \\u0627\\u0644\\u0639\\u0627\\u062f\\u0644 \\u0644\\u0644\\u0645\\u0648\\u0627\\u0631\\u062f.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0645\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0645\\u0648\\u0638\\u0641\\u064a\\u0646: \\u062a\\u062d\\u062f\\u064a\\u062f \\u062d\\u0642\\u0648\\u0642 \\u0648\\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u0645\\u0639\\u0644\\u0645\\u064a\\u0646 \\u0648\\u0623\\u0639\\u0636\\u0627\\u0621 \\u0627\\u0644\\u0647\\u064a\\u0626\\u0629 \\u0627\\u0644\\u062a\\u062f\\u0631\\u064a\\u0633\\u064a\\u0629\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0631 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u0639\\u0642\\u0648\\u062f \\u0648\\u0627\\u0644\\u0645\\u0639\\u064a\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0646\\u0638\\u0627\\u0645\\u064a\\u0629.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u062d\\u0648\\u0643\\u0645\\u0629 \\u0627\\u0644\\u0645\\u062f\\u0631\\u0633\\u0629: \\u062a\\u062d\\u062f\\u064a\\u062f \\u0647\\u064a\\u0643\\u0644 \\u0648\\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0627\\u062a \\u0645\\u062c\\u0627\\u0644\\u0633 \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0645\\u062f\\u0631\\u0633\\u064a\\u0629 \\u0648\\u0627\\u0644\\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0647\\u064a\\u0626\\u0627\\u062a \\u0627\\u0644\\u0623\\u062e\\u0631\\u0649 \\u0627\\u0644\\u062a\\u064a \\u062a\\u062a\\u062e\\u0630 \\u0627\\u0644\\u0642\\u0631\\u0627\\u0631\\u0627\\u062a \\u0641\\u064a \\u0627\\u0644\\u0645\\u0624\\u0633\\u0633\\u0627\\u062a \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645\\u064a\\u0629.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0639\\u0627\\u0644\\u064a: \\u064a\\u063a\\u0637\\u064a \\u0627\\u0644\\u0623\\u0645\\u0648\\u0631 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0627\\u0644\\u0643\\u0644\\u064a\\u0627\\u062a \\u0648\\u0627\\u0644\\u062c\\u0627\\u0645\\u0639\\u0627\\u062a \\u0648\\u0645\\u0624\\u0633\\u0633\\u0627\\u062a \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0627\\u0644\\u0639\\u0627\\u0644\\u064a \\u0627\\u0644\\u0623\\u062e\\u0631\\u0649\\u060c \\u0628\\u0645\\u0627 \\u0641\\u064a \\u0630\\u0644\\u0643 \\u0642\\u0628\\u0648\\u0644 \\u0627\\u0644\\u0637\\u0644\\u0627\\u0628 \\u0648\\u0627\\u0644\\u0645\\u0639\\u0648\\u0646\\u0629 \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629 \\u0648\\u0646\\u0632\\u0627\\u0647\\u0629 \\u0627\\u0644\\u0623\\u0643\\u0627\\u062f\\u064a\\u0645\\u064a\\u0629.<\\/p>\\r\\n    <\\/li>\\r\\n    <li>\\r\\n        <p>\\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 \\u0648\\u0633\\u062c\\u0644\\u0627\\u062a \\u0627\\u0644\\u0637\\u0644\\u0627\\u0628: \\u062d\\u0645\\u0627\\u064a\\u0629 \\u0633\\u0631\\u064a\\u0629 \\u0633\\u062c\\u0644\\u0627\\u062a \\u0627\\u0644\\u0637\\u0644\\u0627\\u0628 \\u0648\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629 \\u0628\\u0645\\u0648\\u062c\\u0628 \\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0645\\u062b\\u0644 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u062d\\u0642\\u0648\\u0642 \\u0627\\u0644\\u0639\\u0627\\u0626\\u0644\\u0629 \\u0641\\u064a \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0648\\u0627\\u0644\\u062e\\u0635\\u0648\\u0635\\u064a\\u0629 (FERPA).<\\/p>\\r\\n    <\\/li>\\r\\n<\\/ol>\\r\\n\\r\\n<p>\\u0647\\u0630\\u0647 \\u0645\\u062c\\u0631\\u062f \\u0628\\u0639\\u0636 \\u0627\\u0644\\u0645\\u062c\\u0627\\u0644\\u0627\\u062a \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0627\\u0644\\u062a\\u064a \\u064a\\u063a\\u0637\\u064a\\u0647\\u0627 \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645. \\u064a\\u0645\\u0643\\u0646 \\u0623\\u0646 \\u062a\\u062e\\u062a\\u0644\\u0641 \\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0628\\u0634\\u0643\\u0644 \\u0643\\u0628\\u064a\\u0631 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0628\\u0644\\u062f\\u0627\\u0646 \\u0648\\u062d\\u062a\\u0649 \\u062f\\u0627\\u062e\\u0644 \\u0645\\u0646\\u0627\\u0637\\u0642 \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u0641\\u064a \\u0628\\u0644\\u062f \\u0645\\u0639\\u064a\\u0646\\u060c \\u0644\\u0630\\u0627 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u0647\\u0645 \\u0623\\u0646 \\u0646\\u0643\\u0648\\u0646 \\u0639\\u0644\\u0649 \\u062f\\u0631\\u0627\\u064a\\u0629 \\u0628\\u0627\\u0644\\u0642\\u0648\\u0627\\u0646\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0644\\u0648\\u0627\\u0626\\u062d \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0627\\u0644\\u0633\\u0644\\u0637\\u0629 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0639\\u0646\\u064a\\u0629 \\u0641\\u064a \\u0645\\u0646\\u0637\\u0642\\u0629 \\u0645\\u0639\\u064a\\u0646\\u0629. \\u0643\\u0645\\u0627 \\u0647\\u0648 \\u0627\\u0644\\u062d\\u0627\\u0644 \\u0645\\u0639 \\u0623\\u064a \\u0642\\u0636\\u0627\\u064a\\u0627 \\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u0629\\u060c \\u0645\\u0646 \\u0627\\u0644\\u0646\\u0635\\u062d \\u0628\\u0627\\u0644\\u0644\\u062c\\u0648\\u0621 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0645\\u062d\\u062a\\u0631\\u0641\\u064a\\u0646 \\u0627\\u0644\\u0642\\u0627\\u0646\\u0648\\u0646\\u064a\\u064a\\u0646 \\u0627\\u0644\\u0645\\u062a\\u062e\\u0635\\u0635\\u064a\\u0646 \\u0641\\u064a \\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645 \\u0639\\u0646\\u062f \\u0627\\u0644\\u062a\\u0639\\u0627\\u0645\\u0644 \\u0645\\u0639 \\u0627\\u0644\\u0642\\u0636\\u0627\\u064a\\u0627 \\u0623\\u0648 \\u0627\\u0644\\u0646\\u0632\\u0627\\u0639\\u0627\\u062a \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645\\u064a\\u0629.<\\/p>"}',
                'icon' => '/images/therapist_main_categories/64cba09c5b7ee.png',
                'id' => 5,
                'image' => '/images/therapist_main_categories/64cba09c5af33.png',
                'is_active' => 1,
                'is_featured' => 1,
                'name' => '{"en":"Education therapy","hi":"\\u0936\\u093f\\u0915\\u094d\\u0937\\u093e \\u0915\\u093e\\u0928\\u0942\\u0928","ar":"\\u0642\\u0627\\u0646\\u0648\\u0646 \\u0627\\u0644\\u062a\\u0639\\u0644\\u064a\\u0645"}',
                'slug' => 'education-therapy-5',
                'updated_at' => '2023-10-10 19:09:18',
            ),
            5 => 
            array (
                'created_at' => '2023-11-03 15:54:46',
                'deleted_at' => '2023-11-03 15:55:32',
                'description' => '{"en":"\\"This is an example text used in the printing and writing industry. These sentences have no meaning.\\"","hi":"\\"This is an example text used in the printing and writing industry. These sentences have no meaning.\\"","ar":"\\"This is an example text used in the printing and writing industry. These sentences have no meaning.\\""}',
                'icon' => '/images/therapist_main_categories/6544d1761e667.png',
                'id' => 6,
                'image' => '/images/therapist_main_categories/6544d1761e4e8.png',
                'is_active' => 1,
                'is_featured' => 1,
                'name' => '{"en":"Religious Freedom and Expression","hi":"\\u0927\\u093e\\u0930\\u094d\\u092e\\u093f\\u0915 \\u0938\\u094d\\u0935\\u0924\\u0902\\u0924\\u094d\\u0930\\u0924\\u093e \\u0914\\u0930 \\u0905\\u092d\\u093f\\u0935\\u094d\\u092f\\u0915\\u094d\\u0924\\u093f","ar":"\\u0627\\u0644\\u062d\\u0631\\u064a\\u0629 \\u0627\\u0644\\u062f\\u064a\\u0646\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062a\\u0639\\u0628\\u064a\\u0631"}',
                'slug' => 'religious-freedom-and-expression-6',
                'updated_at' => '2023-11-03 15:55:32',
            ),
        ));
        
        
    }
}